#!/bin/bash
#
# version 1.0
#
##  This is a wrapper-script for vcr, use your favourite editor to modify it
##  to your needs!
##
##  You want to alter the 'savedir' variable!
## 
##  Mail comments to jtraeger@rhein-ruhr.de 
##
##  copyright (c) 2001, Joerg Traeger
## 
##  Many modifications by Bram Avontuur
## 
##  This program is free software; you can redistribute it and/or modify it
##  under the terms of the GNU General Public License as published by the Free
##  Software Foundation; either version 2 of the License, or (at your option)
##  any later version.
## 
##  This program is distributed in the hope that it will be useful, but
##  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
##  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
##  for more details.
## 
##  You should have received a copy of the GNU General Public License along
##  with this program; if not, write to the Free Software Foundation, Inc.,
##  59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#
# You need a valid config file with some definitions
# This is only a sample, read the documentation of vcr!
#
# [defaults]
# quality = 100
# keyframes = 15
# codec = DivX ;-) low-motion
# attributes = BitRate=4800,Crispness=100
# source = Television
# norm = pal
# framerate = 25
# resolution = 400x300
# audiomode = mono
# audiofrequency = 44
# audiosamplesize = 16
# [PRO7]
# channel = SE17
# [and so on]

savedir="/please/point/to/a/valid/path"

if test "$savedir" = "/please/point/to/a/valid/path" ; then
	echo "Please change the variable 'savedir' in this script to the dir "
	echo "where you want to record your avifiles."
	exit 1
fi

showhelp()
{
echo	"Usage: "
echo ""
echo "$0 [configfile]"
echo ""
exit 1
}

#Some global checks
which vcr >/dev/null || echo "vcr not found" 
#Hmm, don't think this should be in cron.
#which v4l-conf >/dev/null || echo "v4l-conf not found"
test -d "$savedir" || { echo "\"$savedir\" is not a directory."; exit 1; }
test -w "$savedir" || { echo "Can't write in \"$savedir\"."; exit 1; }

if ! test -z "$1" ; then
	vcr_config="$1"
else
	vcr_config="$HOME/.vcrrc"
fi

echo "Using \"$vcr_config\" as vcr's config file (specify it as 1st argument)."

echo "List of tv stations in config file: "
egrep '\[[^]]+\]$' "$vcr_config"  2>/dev/null | egrep -v defaults
ready=0
while ! test $ready -eq 1
do
	echo -n "Name of station to record from: "
	station=""
	#while { read nstation; } ; do station="$station $nstation"; done
	read station
	echo "Station: $station"
	if { grep "\[$station\]" "$vcr_config" >/dev/null; } ; then
		echo "Station found."
		ready=1
	else
		echo "Station not found, try again."
	fi
done

echo ""
echo -n "Duration (--rectime/-t format): "
read duration

echo ""
echo -n "Start time (hh:mm): "
read stime

echo ""
echo -n "Date (mm/dd, or hit enter if you want to record today): "
read date

if test -z "$date" ; then
	date=`date +"%m/%d"`
fi

ready=0
while ! test $ready -eq 1
do
	echo ""
	echo -n "File to save to (dir=\"$savedir\"): "
	read fname

	if ! test -z "$fname" ; then ready=1 ; fi
#voodoo magic
#	dir=`echo $fname|sed -e s+'^\(\([^/]*/\)*\).*'+'\1'+`
#	echo "Directory: $dir"
#	if ! test -d "$dir" ; then
#		echo "Invalid dir \"$dir\", try another filename."
#	else
#		ready=1
#	fi
done

# some tests
freespace=`df -hm "$savedir" |tail -n1 |awk '{print $4}'`
if  [ $freespace -lt 1000 ] ; then
	echo ""
	echo "You have only ${freespace}MB free space!"
  echo "proceed anyway? [y/n]"
  read input
  case "$input" in
      "j"|"y") echo "";;
      *) exit 1;;
  esac
fi

mins=`echo "$stime" | cut -d ':' -f2`
hours=`echo "$stime" | cut -d ':' -f1`
month=`echo "$date" | cut -d '/' -f1`
day=`echo "$date" | cut -d '/' -f2`
cronentry="$mins	$hours	$day	$month	*	`which vcr` -f \"$vcr_config\" -t \"$duration\" -p \"$station\" \"$savedir/$fname\""

echo ""
echo "MIN	HOUR	DAY	MONTH	DOW	COMMAND"
echo "$cronentry"
echo ""
echo -n "Add this cronentry (y/n) ? "
read hellyeah

if ! test "$hellyeah" = "y" ; then
	echo "Okay, maybe another time."
	exit 0
fi

oldcronfile=/etc/passwd
while test -f "$oldcronfile" ; do
	oldcronfile="/tmp/.vcrcron.$RANDOM$RANDOM"
done

crontab -l > "$oldcronfile" 2>/dev/null || { echo "Could not get old crontab"; exit 1; }
echo "$cronentry" >> $oldcronfile
crontab "$oldcronfile" || { echo "Could not write crontab entry."; exit 1; }

echo "Crontab added."
/bin/rm -f "$oldcronfile"
crontab -l
