#!/usr/bin/python

# VBoxGtk: A VirtualBox GTK+ GUI
# Copyright (C) 2008 Francisco J. Vazquez-Araujo, Spain
# franjva at gmail dot com

# This file is part of VBoxGtk.

# VBoxGtk is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# VBoxGtk is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with VBoxGtk.  If not, see <http://www.gnu.org/licenses/>.



# Some useful functions

import re
import random
import subprocess

def command_run(run_str): # FIXME: Ugly function
    running = subprocess.Popen(run_str, stdin = None, stdout = subprocess.PIPE, stderr = subprocess.STDOUT)
    msg = ''
    for line in running.stdout:
        if not (line.startswith('WARNING') or line.startswith('       ') or line.startswith('\n')): msg += line
    if msg.find('rror') != -1 or msg.find('FAILED') != -1 or msg.find('cannot') != -1:
        #if msg.find('vboxdrv kernel module'): 
        #	if not show_msg_module_error(from_thread): return command_run(run_str, verbose, from_thread)
        #else: 
        return (1, msg)
    return (0, msg)
    
def sizestr_to_floatmb(size_str):
    re_res = re.search('([0-9\.]+)MB', size_str);
    if re_res: return float(re_res.group(1))
    re_res = re.search('([0-9\.]+)GB', size_str);
    if re_res: return float(re_res.group(1))*1024
    return 0.0

def basename(path):
    re_res = re.search('.*/(.*)', path);
    if re_res: return re_res.group(1)
    return path

def location(path):
    re_res = re.search('(.*/).*', path);
    if re_res: return re_res.group(1)
    return path
    
def clean_string(string):
    re_res = re.compile('\s+')
    str_temp = re_res.sub(' ', string)
    re_res = re.compile('/')
    return re_res.sub('_', str_temp)

def remove_chars(string, chars):
    re_res = re.compile("[" + chars + "]")
    return re_res.sub('', string)

def random_mac():
    chars = '0123456789ABCDEF'
    mac = '0800'
    for i in range(4,12):
        mac	+= chars[random.randint(0,15)]
    return mac


