/* valavapicheck.vala
 *
 * Copyright (C) 2007  Mathias Hasselmann
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mathias Hasselmann <mathias.hasselmann@gmx.de>
 */

#ifndef __VAPIGEN_VALAVAPICHECK_H__
#define __VAPIGEN_VALAVAPICHECK_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>

G_BEGIN_DECLS


#define VALA_TYPE_VAPI_CHECK (vala_vapi_check_get_type ())
#define VALA_VAPI_CHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_CHECK, ValaVAPICheck))
#define VALA_VAPI_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_CHECK, ValaVAPICheckClass))
#define VALA_IS_VAPI_CHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_CHECK))
#define VALA_IS_VAPI_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_CHECK))
#define VALA_VAPI_CHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_CHECK, ValaVAPICheckClass))

typedef struct _ValaVAPICheck ValaVAPICheck;
typedef struct _ValaVAPICheckClass ValaVAPICheckClass;
typedef struct _ValaVAPICheckPrivate ValaVAPICheckPrivate;

struct _ValaVAPICheck {
	GObject parent_instance;
	ValaVAPICheckPrivate * priv;
};

struct _ValaVAPICheckClass {
	GObjectClass parent_class;
};


ValaVAPICheck* vala_vapi_check_construct (GType object_type, const char* gidlname, ValaCodeContext* context);
ValaVAPICheck* vala_vapi_check_new (const char* gidlname, ValaCodeContext* context);
gint vala_vapi_check_run (ValaVAPICheck* self);
ValaCodeContext* vala_vapi_check_get_context (ValaVAPICheck* self);
ValaSourceFile* vala_vapi_check_get_gidl (ValaVAPICheck* self);
ValaSourceFile* vala_vapi_check_get_metadata (ValaVAPICheck* self);
GType vala_vapi_check_get_type (void);


G_END_DECLS

#endif
