/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraycreationexpression.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <vala/valainitializerlist.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	GeeList* sizes;
	ValaInitializerList* _initializer_list;
	ValaDataType* _element_type;
};
#define VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionPrivate))
enum  {
	VALA_ARRAY_CREATION_EXPRESSION_DUMMY_PROPERTY,
	VALA_ARRAY_CREATION_EXPRESSION_ELEMENT_TYPE,
	VALA_ARRAY_CREATION_EXPRESSION_RANK,
	VALA_ARRAY_CREATION_EXPRESSION_INITIALIZER_LIST
};
static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gpointer vala_array_creation_expression_parent_class = NULL;
static void vala_array_creation_expression_dispose (GObject * obj);


/**
 * Add a size expression.
 */
void vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, ValaExpression* size) {
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	g_return_if_fail (size == NULL || VALA_IS_EXPRESSION (size));
	gee_collection_add (GEE_COLLECTION (self->priv->sizes), size);
}


/**
 * Get the sizes for all dimensions ascending from left to right.
 */
GeeList* vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return GEE_LIST (gee_read_only_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, self->priv->sizes));
}


ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaArrayCreationExpression * self;
	g_return_val_if_fail (element_type == NULL || VALA_IS_DATA_TYPE (element_type), NULL);
	g_return_val_if_fail (initializer_list == NULL || VALA_IS_INITIALIZER_LIST (initializer_list), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "rank", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, rank), __params_it++);
	(__params_it->name = "initializer-list", g_value_init (&__params_it->value, VALA_TYPE_INITIALIZER_LIST), g_value_set_object (&__params_it->value, initializer_list), __params_it++);
	self = g_object_newv (VALA_TYPE_ARRAY_CREATION_EXPRESSION, __params_it - __params, __params);
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	if (vala_array_creation_expression_get_element_type (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_array_creation_expression_get_element_type (self)), visitor);
	}
	{
		GeeList* e_collection;
		GeeIterator* e_it;
		e_collection = self->priv->sizes;
		e_it = gee_iterable_iterator (GEE_ITERABLE (e_collection));
		while (gee_iterator_next (e_it)) {
			ValaExpression* e;
			e = gee_iterator_get (e_it);
			{
				vala_code_node_accept (VALA_CODE_NODE (e), visitor);
				(e == NULL ? NULL : (e = (g_object_unref (e), NULL)));
			}
		}
		(e_it == NULL ? NULL : (e_it = (g_object_unref (e_it), NULL)));
	}
	if (vala_array_creation_expression_get_initializer_list (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_array_creation_expression_get_initializer_list (self)), visitor);
	}
}


static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_array_creation_expression (visitor, self);
}


static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	return FALSE;
}


static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	g_return_if_fail (old_type == NULL || VALA_IS_DATA_TYPE (old_type));
	g_return_if_fail (new_type == NULL || VALA_IS_DATA_TYPE (new_type));
	if (vala_array_creation_expression_get_element_type (self) == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
}


ValaDataType* vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return self->priv->_element_type;
}


void vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_element_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_element_type == NULL ? NULL : (self->priv->_element_type = (g_object_unref (self->priv->_element_type), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_element_type), VALA_CODE_NODE (self));
}


gint vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), 0);
	return self->priv->_rank;
}


void vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self, gint value) {
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	self->priv->_rank = value;
}


ValaInitializerList* vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return self->priv->_initializer_list;
}


void vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self, ValaInitializerList* value) {
	ValaInitializerList* _tmp2;
	ValaInitializerList* _tmp1;
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_initializer_list = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_initializer_list == NULL ? NULL : (self->priv->_initializer_list = (g_object_unref (self->priv->_initializer_list), NULL))), _tmp2);
}


static void vala_array_creation_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (object);
	switch (property_id) {
		case VALA_ARRAY_CREATION_EXPRESSION_ELEMENT_TYPE:
		g_value_set_object (value, vala_array_creation_expression_get_element_type (self));
		break;
		case VALA_ARRAY_CREATION_EXPRESSION_RANK:
		g_value_set_int (value, vala_array_creation_expression_get_rank (self));
		break;
		case VALA_ARRAY_CREATION_EXPRESSION_INITIALIZER_LIST:
		g_value_set_object (value, vala_array_creation_expression_get_initializer_list (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_creation_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (object);
	switch (property_id) {
		case VALA_ARRAY_CREATION_EXPRESSION_ELEMENT_TYPE:
		vala_array_creation_expression_set_element_type (self, g_value_get_object (value));
		break;
		case VALA_ARRAY_CREATION_EXPRESSION_RANK:
		vala_array_creation_expression_set_rank (self, g_value_get_int (value));
		break;
		case VALA_ARRAY_CREATION_EXPRESSION_INITIALIZER_LIST:
		vala_array_creation_expression_set_initializer_list (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass) {
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaArrayCreationExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_array_creation_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_creation_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_array_creation_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_array_creation_expression_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_array_creation_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_array_creation_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_array_creation_expression_real_replace_type;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_CREATION_EXPRESSION_ELEMENT_TYPE, g_param_spec_object ("element-type", "element-type", "element-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_CREATION_EXPRESSION_RANK, g_param_spec_int ("rank", "rank", "rank", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_CREATION_EXPRESSION_INITIALIZER_LIST, g_param_spec_object ("initializer-list", "initializer-list", "initializer-list", VALA_TYPE_INITIALIZER_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_array_creation_expression_init (ValaArrayCreationExpression * self) {
	self->priv = VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE (self);
	self->priv->sizes = GEE_LIST (gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_array_creation_expression_dispose (GObject * obj) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (obj);
	(self->priv->sizes == NULL ? NULL : (self->priv->sizes = (g_object_unref (self->priv->sizes), NULL)));
	(self->priv->_initializer_list == NULL ? NULL : (self->priv->_initializer_list = (g_object_unref (self->priv->_initializer_list), NULL)));
	(self->priv->_element_type == NULL ? NULL : (self->priv->_element_type = (g_object_unref (self->priv->_element_type), NULL)));
	G_OBJECT_CLASS (vala_array_creation_expression_parent_class)->dispose (obj);
}


GType vala_array_creation_expression_get_type (void) {
	static GType vala_array_creation_expression_type_id = 0;
	if (G_UNLIKELY (vala_array_creation_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_init };
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
	}
	return vala_array_creation_expression_type_id;
}




