/* valadbussignal.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valadbussignal.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>

enum  {
	VALA_DBUS_SIGNAL_DUMMY_PROPERTY
};
static gpointer vala_dbus_signal_parent_class = NULL;


ValaDBusSignal* vala_dbus_signal_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	ValaDBusSignal * self;
	g_return_val_if_fail (return_type == NULL || VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_DBUS_SIGNAL, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_signal_set_return_type (VALA_SIGNAL (self), return_type);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static void vala_dbus_signal_class_init (ValaDBusSignalClass * klass) {
	vala_dbus_signal_parent_class = g_type_class_peek_parent (klass);
}


static void vala_dbus_signal_init (ValaDBusSignal * self) {
}


GType vala_dbus_signal_get_type (void) {
	static GType vala_dbus_signal_type_id = 0;
	if (G_UNLIKELY (vala_dbus_signal_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusSignal), 0, (GInstanceInitFunc) vala_dbus_signal_init };
		vala_dbus_signal_type_id = g_type_register_static (VALA_TYPE_SIGNAL, "ValaDBusSignal", &g_define_type_info, 0);
	}
	return vala_dbus_signal_type_id;
}




