/* valanamespacereference.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALANAMESPACEREFERENCE_H__
#define __VALANAMESPACEREFERENCE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_NAMESPACE_REFERENCE (vala_namespace_reference_get_type ())
#define VALA_NAMESPACE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE_REFERENCE, ValaNamespaceReference))
#define VALA_NAMESPACE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE_REFERENCE, ValaNamespaceReferenceClass))
#define VALA_IS_NAMESPACE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE_REFERENCE))
#define VALA_IS_NAMESPACE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE_REFERENCE))
#define VALA_NAMESPACE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE_REFERENCE, ValaNamespaceReferenceClass))

typedef struct _ValaNamespaceReferencePrivate ValaNamespaceReferencePrivate;

/**
 * A reference to a namespace symbol.
 */
struct _ValaNamespaceReference {
	ValaCodeNode parent;
	ValaNamespaceReferencePrivate * priv;
};
struct _ValaNamespaceReferenceClass {
	ValaCodeNodeClass parent;
};

ValaNamespaceReference* vala_namespace_reference_new (const char* name, ValaSourceReference* source_reference);
char* vala_namespace_reference_get_name (ValaNamespaceReference* self);
void vala_namespace_reference_set_name (ValaNamespaceReference* self, const char* value);
ValaSymbol* vala_namespace_reference_get_namespace_symbol (ValaNamespaceReference* self);
void vala_namespace_reference_set_namespace_symbol (ValaNamespaceReference* self, ValaSymbol* value);
GType vala_namespace_reference_get_type (void);

G_END_DECLS

#endif
