/* valaenumvalue.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaenumvalue.h"
#include <vala/valaexpression.h>
#include <vala/valaenumvalue.h>
#include <vala/valacodevisitor.h>
#include <vala/valaenum.h>

struct _ValaEnumValuePrivate {
	ValaExpression* _value;
	char* cname;
};
#define VALA_ENUM_VALUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ENUM_VALUE, ValaEnumValuePrivate))
enum  {
	VALA_ENUM_VALUE_DUMMY_PROPERTY,
	VALA_ENUM_VALUE_VALUE
};
static void vala_enum_value_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_enum_value_parent_class = NULL;
static void vala_enum_value_dispose (GObject * obj);


/**
 * Creates a new enum value.
 *
 * @param name enum value name
 * @return     newly created enum value
 */
ValaEnumValue* vala_enum_value_new (const char* name)
{
	ValaEnumValue * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_object_newv (VALA_TYPE_ENUM_VALUE, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	return self;
}


/**
 * Creates a new enum value with the specified numerical representation.
 *
 * @param name  enum value name
 * @param value numerical representation
 * @return      newly created enum value
 */
ValaEnumValue* vala_enum_value_new_with_value (const char* name, ValaExpression* value)
{
	ValaEnumValue * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value == NULL || VALA_IS_EXPRESSION (value), NULL);
	self = g_object_newv (VALA_TYPE_ENUM_VALUE, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_enum_value_set_value (self, value);
	return self;
}


static void vala_enum_value_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaEnumValue * self;
	self = ((ValaEnumValue*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_enum_value (visitor, self);
}


/**
 * Returns the name of this enum value as it is used in C code.
 *
 * @return the name to be used in C code
 */
char* vala_enum_value_get_cname (ValaEnumValue* self)
{
	const char* __temp3;
	g_return_val_if_fail (VALA_IS_ENUM_VALUE (self), NULL);
	if (self->priv->cname == NULL) {
		ValaEnum* __temp0;
		ValaEnum* en;
		char* __temp2;
		char* __temp1;
		__temp0 = NULL;
		en = (__temp0 = VALA_ENUM (vala_symbol_get_parent_symbol (((ValaSymbol*) self))), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
		__temp2 = NULL;
		__temp1 = NULL;
		self->priv->cname = (__temp2 = g_strdup_printf ("%s%s", (__temp1 = vala_enum_get_cprefix (en)), vala_symbol_get_name (((ValaSymbol*) self))), (self->priv->cname = (g_free (self->priv->cname), NULL)), __temp2);
		(__temp1 = (g_free (__temp1), NULL));
		(en == NULL ? NULL : (en = (g_object_unref (en), NULL)));
	}
	__temp3 = NULL;
	return (__temp3 = self->priv->cname, (__temp3 == NULL ? NULL : g_strdup (__temp3)));
}


ValaExpression* vala_enum_value_get_value (ValaEnumValue* self)
{
	g_return_val_if_fail (VALA_IS_ENUM_VALUE (self), NULL);
	return self->priv->_value;
}


void vala_enum_value_set_value (ValaEnumValue* self, ValaExpression* value)
{
	ValaExpression* __temp7;
	ValaExpression* __temp6;
	g_return_if_fail (VALA_IS_ENUM_VALUE (self));
	__temp7 = NULL;
	__temp6 = NULL;
	self->priv->_value = (__temp7 = (__temp6 = value, (__temp6 == NULL ? NULL : g_object_ref (__temp6))), (self->priv->_value == NULL ? NULL : (self->priv->_value = (g_object_unref (self->priv->_value), NULL))), __temp7);
}


static void vala_enum_value_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaEnumValue * self;
	self = VALA_ENUM_VALUE (object);
	switch (property_id) {
		case VALA_ENUM_VALUE_VALUE:
		g_value_set_object (value, vala_enum_value_get_value (self));
		break;
	}
}


static void vala_enum_value_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaEnumValue * self;
	self = VALA_ENUM_VALUE (object);
	switch (property_id) {
		case VALA_ENUM_VALUE_VALUE:
		vala_enum_value_set_value (self, g_value_get_object (value));
		break;
	}
}


static void vala_enum_value_class_init (ValaEnumValueClass * klass)
{
	vala_enum_value_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaEnumValuePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_enum_value_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_enum_value_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_enum_value_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_enum_value_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ENUM_VALUE_VALUE, g_param_spec_object ("value", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_enum_value_init (ValaEnumValue * self)
{
	self->priv = VALA_ENUM_VALUE_GET_PRIVATE (self);
}


static void vala_enum_value_dispose (GObject * obj)
{
	ValaEnumValue * self;
	ValaEnumValueClass * klass;
	GObjectClass * parent_class;
	self = VALA_ENUM_VALUE (obj);
	(self->priv->_value == NULL ? NULL : (self->priv->_value = (g_object_unref (self->priv->_value), NULL)));
	(self->priv->cname = (g_free (self->priv->cname), NULL));
	klass = VALA_ENUM_VALUE_CLASS (g_type_class_peek (VALA_TYPE_ENUM_VALUE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_enum_value_get_type (void)
{
	static GType vala_enum_value_type_id = 0;
	if (G_UNLIKELY (vala_enum_value_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaEnumValueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_enum_value_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaEnumValue), 0, (GInstanceInitFunc) vala_enum_value_init };
		vala_enum_value_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaEnumValue", &g_define_type_info, 0);
	}
	return vala_enum_value_type_id;
}




