/* valainterfaceregisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#include "valainterfaceregisterfunction.h"
#include <vala/valasymbol.h>
#include <vala/valatypereference.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodenode.h>
#include <gobject/valainterfaceregisterfunction.h>

struct _ValaInterfaceRegisterFunctionPrivate {
	ValaInterface* _interface_reference;
};
#define VALA_INTERFACE_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionPrivate))
enum  {
	VALA_INTERFACE_REGISTER_FUNCTION_DUMMY_PROPERTY,
	VALA_INTERFACE_REGISTER_FUNCTION_INTERFACE_REFERENCE
};
static ValaDataType* vala_interface_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_interface_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base);
static gpointer vala_interface_register_function_parent_class = NULL;
static void vala_interface_register_function_dispose (GObject * obj);


ValaInterfaceRegisterFunction* vala_interface_register_function_new (ValaInterface* iface)
{
	ValaInterfaceRegisterFunction * self;
	g_return_val_if_fail (VALA_IS_INTERFACE (iface), NULL);
	self = g_object_newv (VALA_TYPE_INTERFACE_REGISTER_FUNCTION, 0, NULL);
	vala_interface_register_function_set_interface_reference (self, iface);
	return self;
}


static ValaDataType* vala_interface_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base)
{
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) base);
	return VALA_DATA_TYPE (g_object_ref (vala_interface_register_function_get_interface_reference (self)));
}


static char* vala_interface_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base)
{
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) base);
	return vala_interface_get_type_cname (vala_interface_register_function_get_interface_reference (self));
}


static char* vala_interface_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base)
{
	ValaInterfaceRegisterFunction * self;
	char* __temp2;
	char* __temp3;
	self = ((ValaInterfaceRegisterFunction*) base);
	__temp2 = NULL;
	__temp3 = NULL;
	return (__temp3 = g_strdup_printf ("%s_base_init", (__temp2 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_interface_register_function_get_interface_reference (self)), NULL))), (__temp2 = (g_free (__temp2), NULL)), __temp3);
}


static char* vala_interface_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base)
{
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) base);
	return g_strdup ("NULL");
}


static char* vala_interface_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base)
{
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) base);
	return g_strdup ("0");
}


static char* vala_interface_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base)
{
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) base);
	return g_strdup ("NULL");
}


static char* vala_interface_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base)
{
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) base);
	return g_strdup ("G_TYPE_INTERFACE");
}


static ValaCCodeFragment* vala_interface_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base)
{
	ValaInterfaceRegisterFunction * self;
	ValaCCodeFragment* frag;
	self = ((ValaInterfaceRegisterFunction*) base);
	frag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	{
		GeeCollection* prereq_ref_collection;
		GeeIterator* prereq_ref_it;
		prereq_ref_collection = vala_interface_get_prerequisites (vala_interface_register_function_get_interface_reference (self));
		prereq_ref_it = gee_iterable_iterator (GEE_ITERABLE (prereq_ref_collection));
		while (gee_iterator_next (prereq_ref_it)) {
			ValaTypeReference* prereq_ref;
			prereq_ref = gee_iterator_get (prereq_ref_it);
			{
				ValaDataType* __temp9;
				ValaDataType* prereq;
				ValaCCodeIdentifier* __temp10;
				ValaCCodeFunctionCall* __temp11;
				ValaCCodeFunctionCall* func;
				ValaCCodeIdentifier* __temp14;
				char* __temp13;
				char* __temp12;
				ValaCCodeIdentifier* __temp16;
				char* __temp15;
				ValaCCodeExpressionStatement* __temp17;
				/* register all prerequisites */
				__temp9 = NULL;
				prereq = (__temp9 = vala_type_reference_get_data_type (prereq_ref), (__temp9 == NULL ? NULL : g_object_ref (__temp9)));
				__temp10 = NULL;
				__temp11 = NULL;
				func = (__temp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((__temp10 = vala_ccode_identifier_new ("g_type_interface_add_prerequisite")))), (__temp10 == NULL ? NULL : (__temp10 = (g_object_unref (__temp10), NULL))), __temp11);
				__temp14 = NULL;
				__temp13 = NULL;
				__temp12 = NULL;
				vala_ccode_function_call_add_argument (func, VALA_CCODE_EXPRESSION ((__temp14 = vala_ccode_identifier_new ((__temp13 = g_strdup_printf ("%s_type_id", (__temp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_interface_register_function_get_interface_reference (self)), NULL))))))));
				(__temp14 == NULL ? NULL : (__temp14 = (g_object_unref (__temp14), NULL)));
				(__temp13 = (g_free (__temp13), NULL));
				(__temp12 = (g_free (__temp12), NULL));
				__temp16 = NULL;
				__temp15 = NULL;
				vala_ccode_function_call_add_argument (func, VALA_CCODE_EXPRESSION ((__temp16 = vala_ccode_identifier_new ((__temp15 = vala_data_type_get_type_id (prereq))))));
				(__temp16 == NULL ? NULL : (__temp16 = (g_object_unref (__temp16), NULL)));
				(__temp15 = (g_free (__temp15), NULL));
				__temp17 = NULL;
				vala_ccode_fragment_append (frag, VALA_CCODE_NODE ((__temp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (func)))));
				(__temp17 == NULL ? NULL : (__temp17 = (g_object_unref (__temp17), NULL)));
				(prereq_ref == NULL ? NULL : (prereq_ref = (g_object_unref (prereq_ref), NULL)));
				(prereq == NULL ? NULL : (prereq = (g_object_unref (prereq), NULL)));
				(func == NULL ? NULL : (func = (g_object_unref (func), NULL)));
			}
		}
		(prereq_ref_collection == NULL ? NULL : (prereq_ref_collection = (g_object_unref (prereq_ref_collection), NULL)));
		(prereq_ref_it == NULL ? NULL : (prereq_ref_it = (g_object_unref (prereq_ref_it), NULL)));
	}
	return frag;
	(frag == NULL ? NULL : (frag = (g_object_unref (frag), NULL)));
}


ValaInterface* vala_interface_register_function_get_interface_reference (ValaInterfaceRegisterFunction* self)
{
	g_return_val_if_fail (VALA_IS_INTERFACE_REGISTER_FUNCTION (self), NULL);
	return self->priv->_interface_reference;
}


void vala_interface_register_function_set_interface_reference (ValaInterfaceRegisterFunction* self, ValaInterface* value)
{
	g_return_if_fail (VALA_IS_INTERFACE_REGISTER_FUNCTION (self));
	self->priv->_interface_reference = value;
}


static void vala_interface_register_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaInterfaceRegisterFunction * self;
	self = VALA_INTERFACE_REGISTER_FUNCTION (object);
	switch (property_id) {
		case VALA_INTERFACE_REGISTER_FUNCTION_INTERFACE_REFERENCE:
		g_value_set_object (value, vala_interface_register_function_get_interface_reference (self));
		break;
	}
}


static void vala_interface_register_function_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaInterfaceRegisterFunction * self;
	self = VALA_INTERFACE_REGISTER_FUNCTION (object);
	switch (property_id) {
		case VALA_INTERFACE_REGISTER_FUNCTION_INTERFACE_REFERENCE:
		vala_interface_register_function_set_interface_reference (self, g_value_get_object (value));
		break;
	}
}


static void vala_interface_register_function_class_init (ValaInterfaceRegisterFunctionClass * klass)
{
	vala_interface_register_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaInterfaceRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_interface_register_function_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_interface_register_function_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_interface_register_function_dispose;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_interface_register_function_real_get_type_declaration;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_interface_register_function_real_get_type_struct_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_interface_register_function_real_get_base_init_func_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_interface_register_function_real_get_class_init_func_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_interface_register_function_real_get_instance_struct_size;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_interface_register_function_real_get_instance_init_func_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_interface_register_function_real_get_parent_type_name;
	VALA_TYPE_REGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_interface_register_function_real_get_type_interface_init_statements;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_INTERFACE_REGISTER_FUNCTION_INTERFACE_REFERENCE, g_param_spec_object ("interface-reference", "foo", "bar", VALA_TYPE_INTERFACE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_interface_register_function_init (ValaInterfaceRegisterFunction * self)
{
	self->priv = VALA_INTERFACE_REGISTER_FUNCTION_GET_PRIVATE (self);
}


static void vala_interface_register_function_dispose (GObject * obj)
{
	ValaInterfaceRegisterFunction * self;
	ValaInterfaceRegisterFunctionClass * klass;
	GObjectClass * parent_class;
	self = VALA_INTERFACE_REGISTER_FUNCTION (obj);
	klass = VALA_INTERFACE_REGISTER_FUNCTION_CLASS (g_type_class_peek (VALA_TYPE_INTERFACE_REGISTER_FUNCTION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_interface_register_function_get_type (void)
{
	static GType vala_interface_register_function_type_id = 0;
	if (G_UNLIKELY (vala_interface_register_function_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterfaceRegisterFunction), 0, (GInstanceInitFunc) vala_interface_register_function_init };
		vala_interface_register_function_type_id = g_type_register_static (VALA_TYPE_TYPE_REGISTER_FUNCTION, "ValaInterfaceRegisterFunction", &g_define_type_info, 0);
	}
	return vala_interface_register_function_type_id;
}




