[CCode (cprefix = "Gee", lower_case_cprefix = "gee_")]
namespace Gee {
	[CCode (cheader_filename = "gee/arraylist.h")]
	public class ArrayList<G> : Gee.Iterable<G>, Gee.Collection<G>, Gee.List<G>, GLib.Object {
		public ArrayList (GLib.EqualFunc equal_func = GLib.direct_equal);
		public Gee.Iterator<G> iterator ();
		public bool contains (G item);
		public int index_of (G item);
		public G get (int index);
		public void set (int index, G item);
		public bool add (G item);
		public void insert (int index, G item);
		public bool remove (G item);
		public void remove_at (int index);
		public void clear ();
		public weak int size { get; }
		public weak GLib.EqualFunc equal_func { set; }
	}
	[CCode (cheader_filename = "gee/hashmap.h")]
	public class HashMap<K,V> : Gee.Map<K,V>, GLib.Object {
		public const int MIN_SIZE;
		public const int MAX_SIZE;
		public HashMap (GLib.HashFunc key_hash_func = GLib.direct_hash, GLib.EqualFunc key_equal_func = GLib.direct_equal, GLib.EqualFunc value_equal_func = GLib.direct_equal);
		public Gee.Set<K> get_keys ();
		public Gee.Collection<V> get_values ();
		public bool contains (K key);
		public V get (K key);
		public void set (K key, V value);
		public bool remove (K key);
		public void clear ();
		public weak int size { get; }
		public weak GLib.HashFunc key_hash_func { set; }
		public weak GLib.EqualFunc key_equal_func { set; }
		public weak GLib.EqualFunc value_equal_func { set; }
	}
	[CCode (cheader_filename = "gee/hashset.h")]
	public class HashSet<G> : Gee.Iterable<G>, Gee.Collection<G>, Gee.Set<G>, GLib.Object {
		public const int MIN_SIZE;
		public const int MAX_SIZE;
		public HashSet (GLib.HashFunc hash_func = GLib.direct_hash, GLib.EqualFunc equal_func = GLib.direct_equal);
		public bool contains (G key);
		public Gee.Iterator<G> iterator ();
		public bool add (G key);
		public bool remove (G key);
		public void clear ();
		public weak int size { get; }
		public weak GLib.HashFunc hash_func { set; }
		public weak GLib.EqualFunc equal_func { set; }
	}
	[CCode (cheader_filename = "gee/readonlycollection.h")]
	public class ReadOnlyCollection<G> : Gee.Iterable<G>, Gee.Collection<G>, GLib.Object {
		public ReadOnlyCollection (Gee.Collection<G> collection = null);
		public Gee.Iterator<G> iterator ();
		public bool contains (G item);
		public bool add (G item);
		public bool remove (G item);
		public void clear ();
		public weak int size { get; }
		public Gee.Collection<G> collection { set; }
	}
	[CCode (cheader_filename = "gee/readonlylist.h")]
	public class ReadOnlyList<G> : Gee.Iterable<G>, Gee.Collection<G>, Gee.List<G>, GLib.Object {
		public ReadOnlyList (Gee.List<G> list = null);
		public Gee.Iterator<G> iterator ();
		public bool contains (G item);
		public int index_of (G item);
		public bool add (G item);
		public bool remove (G item);
		public void insert (int index, G item);
		public void remove_at (int index);
		public G get (int index);
		public void set (int index, G o);
		public void clear ();
		public weak int size { get; }
		public Gee.List<G> list { set; }
	}
	[CCode (cheader_filename = "gee/readonlymap.h")]
	public class ReadOnlyMap<K,V> : Gee.Map<K,V>, GLib.Object {
		public ReadOnlyMap (Gee.Map<K,V> map = null);
		public Gee.Set<K> get_keys ();
		public Gee.Collection<V> get_values ();
		public bool contains (K key);
		public V get (K key);
		public void set (K key, V value);
		public bool remove (K key);
		public void clear ();
		public weak int size { get; }
		public Gee.Map<K,V> map { set; }
	}
	[CCode (cheader_filename = "gee/readonlyset.h")]
	public class ReadOnlySet<G> : Gee.Iterable<G>, Gee.Collection<G>, Gee.Set<G>, GLib.Object {
		public ReadOnlySet (Gee.Set<G> set = null);
		public Gee.Iterator<G> iterator ();
		public bool contains (G item);
		public bool add (G item);
		public bool remove (G item);
		public void clear ();
		public weak int size { get; }
		public Gee.Set<G> set { set; }
	}
	[CCode (cheader_filename = "gee/collection.h")]
	public interface Collection<G> : GLib.Object, Gee.Iterable<G> {
		public abstract bool contains (G item);
		public abstract bool add (G item);
		public abstract bool remove (G item);
		public abstract void clear ();
		public weak int size { get; }
	}
	[CCode (cheader_filename = "gee/iterable.h")]
	public interface Iterable<G> : GLib.Object {
		public abstract Gee.Iterator<G> iterator ();
	}
	[CCode (cheader_filename = "gee/iterator.h")]
	public interface Iterator<G> : GLib.Object {
		public abstract bool next ();
		public abstract G get ();
	}
	[CCode (cheader_filename = "gee/list.h")]
	public interface List<G> : GLib.Object, Gee.Collection<G> {
		public abstract G get (int index);
		public abstract void set (int index, G item);
		public abstract int index_of (G item);
		public abstract void insert (int index, G item);
		public abstract void remove_at (int index);
	}
	[CCode (cheader_filename = "gee/map.h")]
	public interface Map<K,V> : GLib.Object {
		public abstract Gee.Set<K> get_keys ();
		public abstract Gee.Collection<V> get_values ();
		public abstract bool contains (K key);
		public abstract V get (K key);
		public abstract void set (K key, V value);
		public abstract bool remove (K key);
		public abstract void clear ();
		public weak int size { get; }
	}
	[CCode (cheader_filename = "gee/set.h")]
	public interface Set<G> : GLib.Object, Gee.Collection<G> {
	}
}
