/* valaccodeoncesection.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

using GLib;

/**
 * Represents a section that should only to processed once.
 */
public class Vala.CCodeOnceSection : CCodeFragment {
	/**
	 * The name of the guarding define.
	 */
	public string! define { get; set construct; }
	
	public CCodeOnceSection (string! def) {
		define = def;
	}
	
	public override void write (CCodeWriter! writer) {
		writer.write_indent ();
		writer.write_string ("#ifndef ");
		writer.write_string (define);
		writer.write_newline ();
		writer.write_string ("#define ");
		writer.write_string (define);
		writer.write_newline ();
		foreach (CCodeNode node in get_children ()) {
			node.write_combined (writer);
		}
		writer.write_indent ();
		writer.write_string ("#endif");
		writer.write_newline ();
	}
	
	public override void write_declaration (CCodeWriter! writer) {
	}
}
