/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Damien CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Damien CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail addresses :
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef SURFACES_POINTS_H
#define SURFACES_POINTS_H

#include <glib.h>

/**
 * SurfacesPoints_normalOffset:
 * 
 * The offset to read the normal values in poly_points.
 */
#define SurfacesPoints_normalOffset 3
/**
 * SurfacesPoints_translationOffset:
 * 
 * The offset to read the translation values in poly_points.
 */
#define SurfacesPoints_translationOffset 6
/**
 * SurfacesPoints_userOffset:
 * 
 * The offset to read the user values in poly_points.
 */
#define SurfacesPoints_userOffset 9

/**
 * SurfacesPoints:
 * @nsurf: number of surfaces encoded in this structure ;
 * @bufferSize: number of stored float in addition to coordinates and
 * normals ;
 * @num_polys: number of polygoins stored in this structure ;
 * @num_points: number of vertices stored in this structure ;
 * @num_polys_surf: number of visible polygons stored in this structure per surface ;
 * @poly_surf_index: gives the id of the surface for each polygon,
 *                   this value ranges from - nsurf to + nsurf. abs(id - 1) gives
 *                   the index of the surface the polygon is attached to. If values
 *                   are negative, then the polygon is currently not used ;
 * @poly_num_vertices: gives the number of vertices used by each polygons ;
 * @poly_vertices: returns the id j of the vertices of polygon i ;
 * @poly_points_data: vectors giving additional data of vertex i.
 *
 * This structure stores geometric description of surfaces.
 * Several surfaces are stored in a single structure for improved performances.
 */
struct _SurfacesPoints
{
  /* Number of different surfaces. */
  int nsurf;
  /* This is the size of additional data on each points in addition to
     (x,y,z) coordinates, normal and translation. Then poly_points is
     allocated to (num_points * (9 + bufferSize)). */
  int bufferSize;

  /* Number of polygons */
  int num_polys, num_points;

  /* Number of polygons per surface. */
  int *num_polys_surf;

  /* Give the number of the surface when the number of the
     polygon is given. */
  int *poly_surf_index;

  /* Return the number of vertices when the id of
     the polygon is given. */
  int *poly_num_vertices;

  /* Return the id in poly_points_data of the vertice j of polygon i. */
  int **poly_vertices;

  /* Vectors giving points and normal of the vertice i. */
  float **poly_points_data;
};
typedef struct _SurfacesPoints SurfacesPoints;

/**
 * isosurfacesPointsInit:
 * @points: a pointer on a set of points (not initialised) ;
 * @bufferSize: the number of additional data to coordinates and
 * normals.
 *
 * Initialise a SurfacesPoints structure. It must be done before any use.
 */
void isosurfacesPointsInit(SurfacesPoints *points, int bufferSize);
/**
 * isosurfacesPointsAllocate:
 * @points: a pointer on a set of points (not allocated) ;
 * @nsurf: the number of stored surfaces ;
 * @npolys: the number of stored polygons ;
 * @npoints: the corresponding number of points ;
 *
 * Allocate the arrays to store a set of points.
 */
void isosurfacesPointsAllocate(SurfacesPoints *points, int nsurf,
			       int npolys, int npoints);
/**
 * isosurfacesPointsFree:
 * @points: a set of points.
 *
 * Free all allocated arrays of the given set of points. The point
 * structure itself is not freed.
 */
void isosurfacesPointsFree(SurfacesPoints *points);

/**
 * isosurfacesPointsRemove:
 * @points: a set of points ;
 * @pos: an integer between 0 and points->nsurf.
 *
 * Remove the points belonging to surface number @pos.
 */
void isosurfacesPointsRemove(SurfacesPoints *points, int pos);

/**
 * isosurfacesPointsTranslate:
 * @points: a set of points.
 * @xyz: a given translation in cartesian coordinates.
 *
 * In devel...
 */
void isosurfacesPointsTranslate(SurfacesPoints *points, float xyz[3]);

/**
 * isosurfacesPointsCheck:
 * @points: a set of points.
 *
 * A debug routines to check that all pointers and size are
 * relevant. It should not be used outside a debug area because it can
 * be slow.
 */
void isosurfacesPointsCheck(SurfacesPoints *points);


#endif
