/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_BASIC_H
#define VISU_BASIC_H

#include <glib.h>
#include "visu_data.h"
#include "visu_tools.h"
#include "coreTools/toolFileFormat.h"
#include "coreTools/toolOptions.h"

G_BEGIN_DECLS

/* Here, basic functions that don't require GTK, are defined. */

/**
 * visuBasicLoad_dataFromFile:
 * @data: a #VisuData object ;
 * @format: a pointer on a format (can be NULL if format is to be
 * guessed) ;
 * @nSet: an integer ;
 * @error: a pointer to store a possible error, location must be initialized to (GError*)0.
 *
 * This calls the load method of the current rendering
 * method. Some informations may be store in @error->message if the returned
 * value is FALSE.
 * The file(s) which is(are) opened is(are) stored in the
 * #VisuData. The @nSet argument is used to load a specific set of
 * nodes if the input format supports it. If @nSet is 0, then the
 * default set of nodes is loaded.
 *
 * Returns: TRUE if everithing is OK, if FALSE, the @error is set and should be freed
 *          with g_error_free().
 */
gboolean visuBasicLoad_dataFromFile(VisuData *data, FileFormat *format,
				    int nSet, GError **error);


/**
 * visuBasicInit:
 *
 * A call to this method is done at startup after having probe the locale of the file
 * system and having initialized the rendering window. It makes the following actions :
 * create the visu object to store the signals, initialize the module part (parameters,
 * and resources), initialize the dump part, the OpenGL part and its extensions, the
 * storage of elements and the 'colorize with data' part.
 */
void visuBasicInit();


/**
 * visuBasicQuit:
 * @data: a pointer to the #GMainLoop.
 *
 * A call to this method makes the #GMainLoop stop.
 *
 * Returns: FALSE, always.
 */
gboolean visuBasicQuit(gpointer data);
/**
 * visuBasicLoad_fileWithoutGtk:
 * @data: a pointer to some user defined data.
 *
 * This method creates a #VisuData from the file which is stored in the
 * #visu_object through a call to setFileLoaded(). And it calls the renderStoredData() method.
 */
void visuBasicLoad_fileWithoutGtk(VisuData *data);
/**
 * visuBasicExport_main:
 *
 * This method is called when V_Sim is in export mode from the command line. 
 *
 * Returns: 0 if everything is normal, 1 if an error occured.
 */
int visuBasicExport_main(void);
/**
 * visuBasicDump:
 * @data: the #VisuData to be exported.
 *
 * This method analyzes the @data parameter to find the file format for export
 * and call dump functions. 
 *
 * Returns: TRUE if no error occured.
 */
gboolean visuBasicDump(VisuData *data);

#define V_SIM_DATA_DIR           visuBasicGet_dataDir()
#define V_SIM_LEGAL_DIR          visuBasicGet_legalDir()
#define V_SIM_PIXMAPS_DIR        visuBasicGet_pixmapsDir()
#define V_SIM_LOCAL_CONF_DIR     visuBasicGet_localDir()
#define V_SIM_OLD_LOCAL_CONF_DIR visuBasicGet_oldLocalDir()
#define V_SIM_PLUGINS_DIR        visuBasicGet_pluginsDir()
#define V_SIM_LOCALE_DIR         visuBasicGet_localeDir()
/**
 * visuBasicSet_paths:
 * @exeLocation: give argv[0] which is the complete path to the executable.
 * 
 * This method sets the paths. On Unix systems, this method sets the paths
 * from macros defined by configure. On Win32 systems, it reads paths in
 * a v_sim.ini file found in the current directory or in the C:\windows.
 */
void visuBasicSet_paths();
const gchar* visuBasicGet_dataDir();
const gchar* visuBasicGet_legalDir();
const gchar* visuBasicGet_pixmapsDir();
const gchar* visuBasicGet_localDir();
const gchar* visuBasicGet_oldLocalDir();
const gchar* visuBasicGet_pluginsDir();
const gchar* visuBasicGet_localeDir();

G_END_DECLS

#endif
