# updown-lib.pl
# XXX acl support
#	XXX upload and/or download only
#	XXX user restriction
#	XXX home dir restriction

do '../web-lib.pl';
&init_config();

if ($module_info{'usermin'}) {
	&switch_to_remote_user();
	&create_user_config_dirs();
	$downloads_dir = "$user_module_config_directory/downloads";
	$atjob_cmd = "$user_module_config_directory/download.pl";
	}
else {
	$downloads_dir = "$module_config_directory/downloads";
	$atjob_cmd = "$module_config_directory/download.pl";
	}

# list_downloads()
sub list_downloads
{
local (@rv, $f);
opendir(DIR, $downloads_dir);
foreach $f (readdir(DIR)) {
	next if ($f !~ /^(\S+)\.down$/);
	local $down = &get_download("$1");
	push(@rv, $down) if ($down);
	}
closedir(DIR);
return @rv;
}

# get_download(id)
sub get_download
{
local %down;
&read_file("$downloads_dir/$_[0].down", \%down) || return undef;
return \%down;
}

# save_download(&download)
sub save_download
{
$_[0]->{'id'} = time().$$ if (!$_[0]->{'id'});
&lock_file($downloads_dir);
mkdir($downloads_dir, 0755);
&unlock_file($downloads_dir);
&lock_file("$downloads_dir/$_[0]->{'id'}.down");
&write_file("$downloads_dir/$_[0]->{'id'}.down", $_[0]);
&unlock_file("$downloads_dir/$_[0]->{'id'}.down");
}

# delete_download(&download)
sub delete_download
{
&lock_file("$downloads_dir/$_[0]->{'id'}.down");
unlink("$downloads_dir/$_[0]->{'id'}.down");
&unlock_file("$downloads_dir/$_[0]->{'id'}.down");
}

# do_download(&download, &callback, &dests)
# Actually download one or more files, and return undef or any error message
sub do_download
{
local $i;
for($i=0; $_[0]->{"url_$i"}; $i++) {
	$progress_callback_url = $_[0]->{"url_$i"};
	$progress_callback_count = $i;
	local $error;
	local $path;
	if (-d $_[0]->{'dir'}) {
		if ($_[0]->{"page_$i"} =~ /([^\/]+)$/) {
			$path = "$_[0]->{'dir'}/$1";
			}
		else {
			$path = "$_[0]->{'dir'}/index.html";
			}
		}
	else {
		$path = $_[0]->{'dir'};
		}
	if ($_[0]->{"proto_$i"} eq "http") {
		&http_download($_[0]->{"host_$i"},
			       $_[0]->{"port_$i"},
			       $_[0]->{"page_$i"},
			       $path,
			       \$error,
			       $_[1],
			       $_[0]->{"ssl_$i"});
		}
	else {
		&ftp_download($_[0]->{"host_$i"},
			      $_[0]->{"page_$i"},
			       $path,
			       \$error,
			       $_[1]);
		}
	if ($error) {
		unlink($path);
		return $error;
		}
	else {
		chown($_[0]->{'uid'}, $_[0]->{'gid'}, $path);
		}
	push(@{$_[2]}, $path);
	}
return undef;
}

# can_write_file(file)
# Returns 1 if some path can be written to, 0 if not
sub can_write_file
{
if ($module_info{'usermin'}) {
	return 1 if (!$config{'home_only'});
	local @dirs = ( &resolve_links($remote_user_info[7]) );
	push(@dirs, split(/\s+/, $config{'root'}));
	local $d;
	foreach $d (@dirs) {
		return 1 if (&is_under_directory($d, $_[0]));
		}
	return 0;
	}
else {
	# Webmin has no restrictions yet
	return 1;
	}
}

1;

