#!/usr/local/bin/perl
# save_imap.cgi
# Create, modify or delete an IMAP folder

require './mailbox-lib.pl';
&ReadParse();
@folders = &list_folders();
$folder = $folders[$in{'idx'}] if (!$in{'new'});
&error_setup($text{'save_err'});
$folder_types{'imap'} || &error($text{'save_ecannot'});

if ($in{'delete'}) {
	# Just delete this folder and cache
	unlink("$user_module_config_directory/$folder->{'id'}.imap");
	system("rm -rf $user_module_config_directory/$folder->{'id'}.cache");
	}
else {
	# Validate inputs
	$in{'name'} =~ /\S/ || &error($text{'save_ename'});
	gethostbyname($in{'server'}) || &check_ipaddress($in{'server'}) ||
		&error($text{'save_eserver'});
	$in{'user'} =~ /\S/ || &error($text{'save_euser'});
	$in{'mailbox_def'} || $in{'mailbox'} =~ /^\S+$/ ||
		&error($text{'save_emailbox2'});
	$in{'perpage_def'} || $in{'perpage'} =~ /^\d+$/ ||
		&error($text{'save_eperpage'});

	# Save the folder
	$imap{'id'} = $folder->{'id'} || time();
	$imap{'name'} = $in{'name'};
	$imap{'server'} = $in{'server'};
	$imap{'user'} = $in{'user'};
	$imap{'pass'} = $in{'pass'};
	$imap{'mailbox'} = $in{'mailbox_def'} ? undef : $in{'mailbox'};
	$in{'perpage_def'} || $in{'perpage'} =~ /^\d+$/ ||
		&error($text{'save_eperpage'});
	local @err = &imap_login(\%imap);
	if ($err[0] == 0) {
		&error($err[1]);
		}
	elsif ($err[0] == 2) {
		&error(&text('save_elogin2', $err[1]));
		}
	elsif ($err[0] == 3) {
		&error(&text('save_emailbox', $err[1]));
		}
	else {
		&imap_logout($err[1], 1);
		}
	&write_file("$user_module_config_directory/$imap{'id'}.imap", \%imap);
	chmod(0700, "$user_module_config_directory/$imap{'id'}.imap");
	}
&redirect("list_folders.cgi");

