#!/usr/local/bin/perl
# edit_imap.cgi
# Display a form for creating or editing an IMAP folder

require './mailbox-lib.pl';
&ReadParse();

if ($in{'new'}) {
	&header($text{'edit_title1'}, "");
	$mode = $in{'mode'};
	}
else {
	&header($text{'edit_title2'}, "");
	@folders = &list_folders();
	$folder = $folders[$in{'idx'}];
	$mode = $folder->{'mode'};
	}
print "<hr>\n";

print "<form action=save_imap.cgi>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<input type=hidden name=mode value='$mode'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'edit_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'edit_mode'}</b></td>\n";
print "<td>$text{'edit_imap'}</td> </tr>\n";

print "<tr> <td><b>$text{'edit_name'}</b></td>\n";
printf "<td><input name=name size=20 value='%s'></td> </tr>\n",
	$folder->{'name'};

print "<tr> <td><b>$text{'edit_iserver'}</b></td>\n";
printf "<td><input name=server size=30 value='%s'></td> </tr>\n",
	$folder->{'server'};

print "<tr> <td><b>$text{'edit_user'}</b></td>\n";
printf "<td><input name=user size=20 value='%s'></td> </tr>\n",
	$folder->{'user'};

print "<tr> <td><b>$text{'edit_pass'}</b></td>\n";
printf "<td><input type=password name=pass size=20 value='%s'></td> </tr>\n",
	$folder->{'pass'};

print "<tr> <td><b>$text{'edit_mailbox'}</b></td>\n";
printf "<td><input type=radio name=mailbox_def value=1 %s> %s\n",
	$folder->{'mailbox'} ? "" : "checked", $text{'edit_imapinbox'};
printf "<input type=radio name=mailbox_def value=0 %s> %s\n",
	$folder->{'mailbox'} ? "checked" : "", $text{'edit_imapother'};
printf "<input name=mailbox size=20 value='%s'></td> </tr>\n",
	$folder->{'mailbox'};

print "<tr> <td><b>$text{'edit_perpage'}</b></td>\n";
printf "<td><input type=radio name=perpage_def value=1 %s> %s\n",
	$folder->{'perpage'} ? "" : "checked", $text{'default'};
printf "<input type=radio name=perpage_def value=0 %s> %s\n",
	$folder->{'perpage'} ? "checked" : "";
printf "<input name=perpage size=5 value='%s'></td> </tr>\n",
	$folder->{'perpage'};

print "<tr> <td><b>$text{'edit_sentview'}</b></td>\n";
printf "<td><input type=radio name=sent value=1 %s> %s\n",
	$folder->{'sent'} ? "checked" : "", $text{'yes'};
printf "<input type=radio name=sent value=0 %s> %s</td> </tr>\n",
	$folder->{'sent'} ? "" : "checked", $text{'no'};

print "</table></td></tr></table>\n";
if ($in{'new'}) {
	print "<input type=submit value='$text{'create'}'>\n";
	}
else {
	print "<input type=submit value='$text{'save'}'>\n";
	print "<input type=submit name=delete value='$text{'delete'}'>\n";
	}
print "</form>\n";

print "<hr>\n";
&footer("list_folders.cgi", $text{'folders_return'});

