var useragentswitcher_windowType = null;

// Clears the user agent
function useragentswitcher_clearUserAgent()
{
    window.opener.useragentswitcher_appName     = null;
    window.opener.useragentswitcher_appVersion  = null;
    window.opener.useragentswitcher_description = null;
    window.opener.useragentswitcher_platform    = null;
    window.opener.useragentswitcher_userAgent   = null;
}

// Initializes the user agent dialog box
function useragentswitcher_initializeUserAgent()
{
    var stringBundle = document.getElementById("useragentswitcher-string-bundle");

    useragentswitcher_windowType = window.arguments[0];

    // If the window type is add
    if(useragentswitcher_windowType == "add")
    {
        document.title = stringBundle.getString("useragentswitcher_addUserAgentTitle");
    }
    else if(useragentswitcher_windowType == "default")
    {
        var description = document.getElementById("useragentswitcher.description");

        useragentswitcher_retrieveDefault();

        document.title    = stringBundle.getString("useragentswitcher_defaultUserAgentTitle");
        description.value = stringBundle.getString("useragentswitcher_defaultDescription");

        description.setAttribute("readonly", true);
        document.getElementById("useragentswitcher.app.name").setAttribute("readonly", true);
        document.getElementById("useragentswitcher.app.version").setAttribute("readonly", true);
        document.getElementById("useragentswitcher.platform").setAttribute("readonly", true);
        document.getElementById("useragentswitcher.user.agent").setAttribute("readonly", true);
        document.getElementById("useragentswitcher.vendor").setAttribute("readonly", true);
        document.getElementById("useragentswitcher.vendor.sub").setAttribute("readonly", true);
    }
    else if(useragentswitcher_windowType == "edit")
    {
        document.title = stringBundle.getString("useragentswitcher_editUserAgentTitle");

        document.getElementById("useragentswitcher.app.name").value    = window.arguments[1];
        document.getElementById("useragentswitcher.app.version").value = window.arguments[2];
        document.getElementById("useragentswitcher.description").value = window.arguments[3];
        document.getElementById("useragentswitcher.platform").value    = window.arguments[4];
        document.getElementById("useragentswitcher.user.agent").value  = window.arguments[5];
        document.getElementById("useragentswitcher.vendor").value      = window.arguments[6];
        document.getElementById("useragentswitcher.vendor.sub").value  = window.arguments[7];
    }
}

// Retrieves the default user agent
function useragentswitcher_retrieveDefault()
{
    var appName     = null;
    var appVersion  = null;
    var description = null;
    var platform    = null;
    var userAgent   = null;
    var vendor      = null;
    var vendorSub   = null;

    // If the app name is being overridden
    if(useragentswitcher_isPreferenceSet("general.appname.override"))
    {
        appName = useragentswitcher_getStringPreference("general.appname.override", true);

        useragentswitcher_deletePreference("general.appname.override");
    }

    // If the app version is being overridden
    if(useragentswitcher_isPreferenceSet("general.appversion.override"))
    {
        appVersion = useragentswitcher_getStringPreference("general.appversion.override", true);

        useragentswitcher_deletePreference("general.appversion.override");
    }

    // If the platform is being overridden
    if(useragentswitcher_isPreferenceSet("general.platform.override"))
    {
        platform = useragentswitcher_getStringPreference("general.platform.override", true);

        useragentswitcher_deletePreference("general.platform.override");
    }

    // If the user agent is being overridden
    if(useragentswitcher_isPreferenceSet("general.useragent.override"))
    {
        userAgent = useragentswitcher_getStringPreference("general.useragent.override", true);

        useragentswitcher_deletePreference("general.useragent.override");
    }

    // If the vendor is being overridden
    if(useragentswitcher_isPreferenceSet("general.useragent.vendor"))
    {
        vendor = useragentswitcher_getStringPreference("general.useragent.vendor", true);

        useragentswitcher_deletePreference("general.useragent.vendor");
    }

    // If the vendor sub is being overridden
    if(useragentswitcher_isPreferenceSet("general.useragent.vendorSub"))
    {
        vendorSub = useragentswitcher_getStringPreference("general.useragent.vendorSub", true);

        useragentswitcher_deletePreference("general.useragent.vendorSub");
    }

    document.getElementById("useragentswitcher.app.name").value    = navigator.appName;
    document.getElementById("useragentswitcher.app.version").value = navigator.appVersion;
    document.getElementById("useragentswitcher.platform").value    = navigator.platform;
    document.getElementById("useragentswitcher.user.agent").value  = navigator.userAgent;
    document.getElementById("useragentswitcher.vendor").value      = navigator.vendor;
    document.getElementById("useragentswitcher.vendor.sub").value  = navigator.vendorSub;

    // If the app name was being overridden
    if(appName)
    {
        useragentswitcher_setStringPreference("general.appname.override", appName);
    }

    // If the app version was being overridden
    if(appVersion)
    {
        useragentswitcher_setStringPreference("general.appversion.override", appVersion);
    }

    // If the platform was being overridden
    if(platform)
    {
        useragentswitcher_setStringPreference("general.platform.override", platform);
    }

    // If the user agent was being overridden
    if(userAgent)
    {
        useragentswitcher_setStringPreference("general.useragent.override", userAgent);
    }

    // If the vendor was being overridden
    if(vendor)
    {
        useragentswitcher_setStringPreference("general.useragent.vendor", vendor);
    }

    // If the vendor sub was being overridden
    if(vendorSub)
    {
        useragentswitcher_setStringPreference("general.useragent.vendorSub", vendorSub);
    }
}

// Saves a user agent
function useragentswitcher_saveUserAgent()
{
    // If the window type is add or edit
    if(useragentswitcher_windowType == "add" || useragentswitcher_windowType == "edit")
    {
        var appName     = document.getElementById("useragentswitcher.app.name").value.trim();
        var appVersion  = document.getElementById("useragentswitcher.app.version").value.trim();
        var description = document.getElementById("useragentswitcher.description").value.trim();
        var platform    = document.getElementById("useragentswitcher.platform").value.trim();
        var userAgent   = document.getElementById("useragentswitcher.user.agent").value.trim();
        var vendor      = document.getElementById("useragentswitcher.vendor").value.trim();
        var vendorSub   = document.getElementById("useragentswitcher.vendor.sub").value.trim();

        // If the description is empty
        if(!description)
        {
            alert(document.getElementById("useragentswitcher-string-bundle").getString("useragentswitcher_emptyDescription"));

            return false;
        }
        else
        {
            window.opener.useragentswitcher_appName     = appName;
            window.opener.useragentswitcher_appVersion  = appVersion;
            window.opener.useragentswitcher_description = description;
            window.opener.useragentswitcher_platform    = platform;
            window.opener.useragentswitcher_userAgent   = userAgent;
            window.opener.useragentswitcher_vendor      = vendor;
            window.opener.useragentswitcher_vendorSub   = vendorSub;

            return true;
        }
    }
    else
    {
        return true;
    }
}
