// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-
Components.utils.import("resource://unity/unity-misc-utils.js");

var EXPORTED_SYMBOLS = [ "makeAPI" ];

function makeAPI(setTimeout, contextAddApplicationActions, init, toDataURL, log, uwa, unity, CallbackManager, acceptDataCb) {
    var api;
    function checkString(str, allowUndef) {
        if (allowUndef && str == undefined) {
            return;
        }
        if (!str || typeof(str) !== 'string') {
            throw new TypeError("incorrect argument");
        }
   }
   function findName(func, prefix, obj) {
        if (!prefix) {
            return findName(func, 'Unity.', api);
        }
        var keys = Object.keys(obj);
        for (var i = 0; i < keys.length; i++) {
            if (typeof(keys[i]) !== 'string') {
                continue;
            }
            var descr = Object.getOwnPropertyDescriptor(obj, keys[i]);
            if (descr.value === func) {
                return prefix + keys[i];
            }
            if (descr.value instanceof Object) {
                var res = findName(func, prefix + keys[i] + '.', obj[keys[i]]);
                if (res)
                    return res;
            }
            if (obj.__lookupGetter__(keys[i]) === func) {
                return prefix + keys[i];
            }
            if (obj.__lookupSetter__(keys[i]) === func) {
                return prefix + keys[i];
            }
        }
        return null;
    }
    function stringify(obj) {
        if (obj === undefined)
            return obj;
        if (obj === null)
            return obj;
        if (typeof(obj) == 'string')
            return obj;
        if (typeof(obj) == 'number')
            return obj;
        if (typeof(obj) == 'function')
            return String(obj);
        var dump = {};
        for (var i in obj) {
            if (obj.hasOwnProperty(i))
                dump[i] = stringify(obj[i]);
        }
        return dump;
    }
    function stringifyArgs(obj) {
        var args = [];
        for (var i = 0; i < obj.length; i++) {
            args.push(stringify(obj[i]));
        }
        var res = JSON.stringify(args);
        return res.substr(1, res.length - 2);
    }
    function createArgumentsSanitaizer(func, argsDesc, callback) {
        return function () {
            var realArgs = arguments;

            var name = findName(arguments.callee);
            log(String(name) + '(' + stringifyArgs(arguments) + ')');

	    if (unity.context == null || unity.contextReady == false) {return;}
            var k = 0;
            function argumentSanitaizer(desc, arg) {
                if (!desc) {
		    throw new InternalError("argument description is null");
                }
                if (desc.dummy) {
                    k--;
                    return null;
                }
                if (desc.array) {
                    if (!(desc.array instanceof Object) || !(desc.array.element instanceof Object)) {
                        throw new InternalError("invalid argument description");
                    }

                    try {
                        for (var j = 0; j < arg.length; j++) {
                            argumentSanitaizer(desc.array.element, arg[j]);
                        }
                    } catch (x) {
                        throw new TypeError("incorrect argument");
                    }
                    return arg;
                }
                if (desc.obj) {
                    if (!(desc.obj instanceof Object)) {
                        throw new InternalError("invalid argument description");
                    }
                    var res = [], i;
                    for (i in desc.obj) {
                        if (desc.obj.hasOwnProperty(i)) {
                            res.push(null);
                        }
                    }
                    for (i in desc.obj) {
                        if (desc.obj.hasOwnProperty(i)) {
                            res[desc.obj[i].place] = argumentSanitaizer(desc.obj[i], arg[i]);
                        }
                    }
                    return res;
                }
                if (desc.str) {
                    if (desc.allowNull && !arg) {
                        return null;
                    }
                    checkString(arg, false);
                    return arg;
                }
                if (desc.number) {
                    if (typeof(arg) !== 'number' && typeof(arg) !== 'boolean')
                        throw new TypeError("incorrect argument");
                    return arg;
                }
                if (!desc.type) {
                    throw new InternalError("argument description miss required parameter");
                }
                if ((arg instanceof desc.type) || (desc.type === Function && ((typeof arg) === 'function'))
                    || (arg === null && desc.allowNull)) {
                    if (desc.type === Function) {
                        if (!arg) {
                            return null;
                        }

                        var id;
                        if (desc.argAsCallbackId !== undefined) {
                            id = realArgs[desc.argAsCallbackId];
                        }
                        if (desc.js)
                            return arg;
                        return CallbackManager.makeCallback(uwa.ContextActionCallbackType,
							    function (context, user_data) {
                                                                arg();
                                                            }, name, id);
                    }
                    return arg;
                } else {
                    throw new TypeError("incorrect argument");
                }
                throw new InternalError("unreacheable");
            }
            var args = [unity.context], i;
            for (i = 0; i < argsDesc.length; i++) {
                if (k >= realArgs.length && k > 0 && !argsDesc[i].dummy) {
                    throw new Error("not enough arguments");
                }

                var value = argumentSanitaizer(argsDesc[i], realArgs[k]);
                k++;
                if (argsDesc[i].obj) {
                    args = args.concat(value);
                } else {
                    args.push(value);
                }
            }

            if (k < realArgs.length) {
                throw new Error("too much arguments");
            }

            if (callback)
                callback.apply(uwa, args);
            if (func)
                return Function.apply.apply(func, [uwa, args]);
        };
    }

    var actions = [];
    var timeoutId = null;
    function fireContextAddApplicationActions() {
        timeoutId = null;
        if (unity.context == null || unity.contextReady == false) {return;}
        contextAddApplicationActions(actions);
    }
    var firstAddStaticAction = true;
    api = {
	init: function(props) {
            checkString(props.name, false);
            checkString(props.iconUrl, true);
            checkString(props.domain, true);
            checkString(props.login, true);
            checkString(props.mimeTypes, true);
            checkString(props.homepage, true);
            if (props.homepage && !/^(http|https|file):\/\//.test(props.homepage)) {
                throw new TypeError("incorrect argument");
            }
            init(props);
	},
        acceptData: createArgumentsSanitaizer(null, [{ array: { element: { str: true } } },
                                                   { type: Function, js: true }],
                                              acceptDataCb)
        ,
	addAction: createArgumentsSanitaizer(null, [{ str: true },
                                                    { type: Function, argAsCallbackId: 0 }],
                                                    function (context, name, callback) {
            actions.push({ name: name, callback: callback });
            if (timeoutId == null) {
                timeoutId = setTimeout(fireContextAddApplicationActions, 100);
            }
        }),
	clearAction: createArgumentsSanitaizer(uwa.context_remove_application_action,
					       [{ str: true }], fireContextAddApplicationActions),
	clearActions: createArgumentsSanitaizer(uwa.context_remove_application_actions,
					        [],
                                                function () {
            fireContextAddApplicationActions();
            CallbackManager.releaseCallback('Unity.addAction');
        }),

	MediaPlayer: {
            init: createArgumentsSanitaizer(uwa.music_player_init, [{ str: true }]),

            onPlayPause: createArgumentsSanitaizer(uwa.music_player_on_play_pause_callback,
                                                   [{ type: Function, allowNull: true }, { dummy: true }]),

            onPrevious: createArgumentsSanitaizer(uwa.music_player_on_previous_callback,
                                                  [{ type: Function, allowNull: true }, { dummy: true }]),

            onNext: createArgumentsSanitaizer(uwa.music_player_on_next_callback,
                                              [{ type: Function, allowNull: true }, { dummy: true }]),

            setTrack: createArgumentsSanitaizer(uwa.music_player_set_track,
                                                [{ obj: { artist: { str: true, place: 0, allowNull: true },
                                                          album: { str: true, place: 1, allowNull: true },
                                                          title: { str: true, place: 2 },
                                                          artLocation: { str: true, place: 3, allowNull: true } } }]),

            setCanGoNext: createArgumentsSanitaizer(uwa.music_player_set_can_go_next, [{ number: true }]),

            setCanGoPrevious: createArgumentsSanitaizer(uwa.music_player_set_can_go_previous, [{ number: true }]),

            setCanPlay: createArgumentsSanitaizer(uwa.music_player_set_can_play, [{ number: true }]),

            setCanPause: createArgumentsSanitaizer(uwa.music_player_set_can_pause, [{ number: true }]),

            setPlaybackState: createArgumentsSanitaizer(uwa.music_player_set_playback_state, [{ number: true }]),

            getPlaybackState: createArgumentsSanitaizer(null
                                                        , [{ type: Function }]
                                                        , function (callback) {
                                                          callback (uwa.music_player_get_playback_state(unity.context));
                                                        }),

            PlaybackState: {PLAYING: 0, PAUSED:1}
	},

	Notification: {
            showNotification: createArgumentsSanitaizer(uwa.notification_show_notification,
                                                        [{ str: true }, { str: true }, { str: true, allowNull: true }])
	},

	Launcher: {
            setCount: createArgumentsSanitaizer(uwa.launcher_set_count,
                                                [{ number: true }]),
            clearCount: createArgumentsSanitaizer(uwa.launcher_clear_count,
                                                  []),
            setProgress: createArgumentsSanitaizer(uwa.launcher_set_progress,
                                                   [{ number: true }]),
            clearProgress: createArgumentsSanitaizer(uwa.launcher_clear_progress,
                                                     []),
            setUrgent: createArgumentsSanitaizer(uwa.launcher_set_urgent,
                                                 []),
            _addAction: createArgumentsSanitaizer(uwa.launcher_add_action,
                                                  [{ str: true }, { type: Function, argAsCallbackId: 0 }, { dummy: true }]),
            _addStaticAction: createArgumentsSanitaizer(uwa.launcher_add_static_action,
                                                        [{ str: true }, { str: true }]),
            addAction: function (arg1, arg2) {
                if (typeof(arg2) === 'string') {
                    if (firstAddStaticAction)
                        uwa.launcher_remove_static_actions(unity.context);
                    firstAddStaticAction = false;
                    this._addStaticAction(arg1, arg2);
                } else {
                    this._addAction(arg1, arg2);
                }
            },
            removeAction: createArgumentsSanitaizer(uwa.launcher_remove_action,
                                                 [{ str: true }]),
            removeActions: createArgumentsSanitaizer(uwa.launcher_remove_actions,
                                                 [], function () {CallbackManager.releaseCallback('Unity.Launcher.addAction');})
	},

	MessagingIndicator: {
            addAction: createArgumentsSanitaizer(uwa.indicator_add_action,
                                                 [{ str: true }, { type: Function, argAsCallbackId: 0 }, { dummy: true }]),
            showIndicator: function(name, properties) {
                log('Unity.MessagingIndicator.showIndicator(' + stringifyArgs(arguments) + ')');

		if (unity.context == null) {return};

                checkString(name, false);

		uwa.indicator_show_indicator(unity.context, String(name));
		for (i in properties) {
                    if (i == "time") {
			uwa.indicator_set_property(unity.context, String(name), i, UnityMiscUtils.toISODate(properties[i]));
                    }
                    else if (i == "icon") {
			uwa.indicator_set_property_icon(unity.context, String(name), i, String(properties[i]));
                    }
                    else if (i == "callback") {
			var callback = CallbackManager.makeCallback(uwa.IndicatorCallbackType,
								    (function (propidx) {
                                                                       return function (context, user_data) {
                                                                         (properties[propidx])();
                                                                       };
                                                                     })(i),
                                                                    'Unity.MessagingIndicator.showIndicator', name);

			uwa.indicator_set_callback(unity.context, String(name), callback, null);
                    }
		    else if (i == "count") {
			uwa.indicator_set_property(unity.context, String(name), i, String(Number(properties[i])));
		    }
                    else {
			uwa.indicator_set_property(unity.context, String(name), i, String(properties[i]));
                    }
		}
            },
            clearIndicator: createArgumentsSanitaizer(uwa.indicator_clear_indicator, [{ str: true }]),
            clearIndicators: createArgumentsSanitaizer(uwa.indicator_clear_indicators, [], function () {CallbackManager.releaseCallback('Unity.MessagingIndicator.showIndicator');})
	},

	toDataURL: function (uri, callback, sx, sy, sw, sh) {
            toDataURL(uri, callback, sx, sy, sw, sh);
	}
    };

    return api;
}
