
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 1 "unites.y"

/* inclusions, dfinition */
#include <string>
#include <sstream>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <gmp.h>
#include <gmpxx.h>
#include "unites.h"
#include <iostream>

  int yylex();
  int yyerror(const char * msg);

  const char * unit_names[BU_LAST]={"m","kg","s","A","K","mol","cd"};

/*   typedef struct{ */
/*     int i; */
/*     mpq_class multip, maxmultip, wanted_multip;  */
/*     /\* mutiplicators are mutiprecisions rationals *\/ */
/*     uniteSI unite; */
/*     int base[BU_LAST]; */
/*     char * s, * v; */
/*     std::string wanted_unit; */
/*     mpq_class val; */
/*     /\* values are mutiprecisions rationals *\/ */
/*     int signif; */
/*     int pcent; /\* percent tolerance *\/ */
/*   } yystype; */
  
  class yystype{
  public:
    int i;
    mpq_class multip, maxmultip, wanted_multip;
    /* mutiplicators are mutiprecisions rationals */
    uniteSI unite;
    int base[BU_LAST];
    char * s, * v;
    std::string wanted_unit;
    mpq_class val;
    /* values are mutiprecisions rationals */
    int signif;
    int pcent; /* percent tolerance */
    yystype(){
      s=(char*) NULL;
      v=(char*) NULL;
    }
  };

  std::ostream & operator << (std::ostream & o, yystype data);
  std::ostream & operator << (std::ostream & o, yystype data){
    o << "YYSTYPE[" <<"i="<<data.i<<", multip="<<data.multip;
    o<<", maxmultip="<<data.maxmultip<<", wanted_multip="<<data.wanted_multip;
    o<<", unite="<<data.unite<<", base={";
    for (int i=0;i<BU_LAST;i++){
      o<<data.base[i]<<" ";
    }
    o<<"}";
    if(data.s!=NULL){ o<<", s="<<data.s;}else{o<<", s=NULL";}
    if(data.v!=NULL){o<<", v="<<data.v;}else{o<<", v=NULL";}
    o<<", wanted_unit="<<data.wanted_unit;
    o<<", val="<<data.val<<", signif="<<data.signif<<", pcent="<<data.pcent;
    o<<"] ";
    return o;
  }
  
#define YYSTYPE yystype 

 extern FILE * yyin;

/* variables globales */
#define MAXBUF 255
 char buffer[MAXBUF+1], buffer2[MAXBUF+1];
 yystype result;
 mpq_class val_decimal; /* a multiprecision rational */
 int val_int, count_signif=0;
 long pos;

/* les units du SI */
/* Handbook of Chemistry & Physics 78, CRC Press 1997, page 1-20 */
unite_data unites[TU_LAST] ={
/*TUh*/   {"h",    "seconde",3600.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUmin*/ {"min",   "seconde", 60.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUm*/   {"m",      "mtre",   1.0,     { 1, 0, 0, 0, 0, 0, 0}},
/*TUg*/   {"g",    "kilogramme",1.0e-3,  { 0, 1, 0, 0, 0, 0, 0}},
/*TUs*/   {"s",      "seconde", 1.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUA*/   {"A",      "ampre",  1.0,     { 0, 0, 0, 1, 0, 0, 0}},
/*TUK*/   {"K",      "kelvin",  1.0,     { 0, 0, 0, 0, 1, 0, 0}},
/*TUmol*/ {"mol",    "mol",     1.0,     { 0, 0, 0, 0, 0, 1, 0}},
/*TUcd*/  {"cd",     "candela", 1.0,     { 0, 0, 0, 0, 0, 0, 1}},
/*TUHz*/  {"Hz",     "hetrz",   1.0,     { 0,-1, 0, 0, 0, 0, 0}},
/*TUN*/   {"N",      "newton",  1.0,     { 1, 1,-2, 0, 0, 0, 0}},
/*TUPa*/  {"Pa",     "pascal",  1.0,     {-1, 1,-2, 0, 0, 0, 0}},
/*TUJ*/   {"J",      "joule",   1.0,     { 2, 1,-2, 0, 0, 0, 0}},
/*TUW */  {"W",      "watt",    1.0,     { 2, 1,-3, 0, 0, 0, 0}},
/*TUC*/   {"C",      "coulomb", 1.0,     { 0, 0, 1, 1, 0, 0, 0}},
/*TUV*/   {"V",      "volt",    1.0,     { 2, 1,-3,-1, 0, 0, 0}},
/*TUohm*/ {"\\Omega","ohm",     1.0,     { 2, 1,-3,-2, 0, 0, 0}},
/*TUS*/   {"S",      "siemens", 1.0,     {-2,-1, 3, 2, 0, 0, 0}},
/*TUF*/   {"F",      "farad",   1.0,     {-2,-1, 4, 2, 0, 0, 0}},
/*TUT*/   {"T",      "tesla",   1.0,     { 0, 1,-2,-1, 0, 0, 0}},
/*TUWb*/  {"Wb",     "weber",   1.0,     { 2, 1,-2,-1, 0, 0, 0}},
/*TUH*/   {"H",      "henry",   1.0,     { 2, 1,-2,-2, 0, 0, 0}},
/*TUlm*/  {"lm",     "lumen",   1.0,     { 0, 0, 0, 0, 0, 0, 1}},
/*TUlx*/  {"lx",     "lux",     1.0,     {-2, 0, 0, 0, 0, 0, 1}},
/*TUBq */ {"Bq",     "becquerel",1.0,    { 0, 0,-1, 0, 0, 0, 0}},
/*TUGy*/  {"Gy",     "gray",     1.0,    { 2, 0,-2, 0, 0, 0, 0}},
/*TUSv*/  {"Sv",     "sievert",  1.0,    { 2, 0,-2, 0, 0, 0, 0}},
/*TUrad*/ {"rad",    "radian",   1.0,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUsr*/  {"sr" ,    "stradian",1.0,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUnull*/{"" ,    "sans unit",1.0,     { 0, 0, 0, 0, 0, 0, 0}},
/*TUda*/  {"", "degr", M_PI/180.0,     { 0, 0, 0, 0, 0, 0, 0}},
/*TUma*/  {"'", "minute", M_PI/10800,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUsa*/  {"''","seconde",M_PI/648000 ,  { 0, 0, 0, 0, 0, 0, 0}},
/*TUangs*/ {"\\o{A}", "angstrm", 1e-10, { 1, 0, 0, 0, 0, 0, 0}},
/*TUbarn*/ {"b", "barn", 1e-28,          { 2, 0, 0, 0, 0, 0, 0}},
/*TUare*/  {"a", "are", 1e2,             { 2, 0, 0, 0, 0, 0, 0}},
/*TUl*/    {"L", "litre", 1e-3,          { 3, 0, 0, 0, 0, 0, 0}},
/*TUt*/    {"t", "tonne", 1e3,           { 0, 1, 0, 0, 0, 0, 0}},
/*TUbar*/  {"bar", "bar", 1e5,           {-1, 1,-2, 0, 0, 0, 0}},
/*TUeV*/   {"eV", "eV", 1.60218e-19,     { 2, 1,-2, 0, 0, 0, 0}},
/*TUuam*/  {"uma", "uma", 1.66054e-27,   { 0, 1, 0, 0, 0, 0, 0}}
};

unite_data pref_units[] ={
/*TUm*/   {"m",      "mtre",   1.0,     { 1, 0, 0, 0, 0, 0, 0}},
/*   */   {"kg",    "kilogramme",1.0,    { 0, 1, 0, 0, 0, 0, 0}},
/*TUs*/   {"s",      "seconde", 1.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUA*/   {"A",      "ampre",  1.0,     { 0, 0, 0, 1, 0, 0, 0}},
/*TUK*/   {"K",      "kelvin",  1.0,     { 0, 0, 0, 0, 1, 0, 0}},
/*TUmol*/ {"mol",    "mol",     1.0,     { 0, 0, 0, 0, 0, 1, 0}},
/*TUcd*/  {"cd",     "candela", 1.0,     { 0, 0, 0, 0, 0, 0, 1}},
/*TUHz*/  {"Hz",     "hetrz",   1.0,     { 0,-1, 0, 0, 0, 0, 0}},
/*TUN*/   {"N",      "newton",  1.0,     { 1, 1,-2, 0, 0, 0, 0}},
/*TUPa*/  {"Pa",     "pascal",  1.0,     {-1, 1,-2, 0, 0, 0, 0}},
/*TUJ*/   {"J",      "joule",   1.0,     { 2, 1,-2, 0, 0, 0, 0}},
/*TUW */  {"W",      "watt",    1.0,     { 2, 1,-3, 0, 0, 0, 0}},
/*TUC*/   {"C",      "coulomb", 1.0,     { 0, 0, 1, 1, 0, 0, 0}},
/*TUV*/   {"V",      "volt",    1.0,     { 2, 1,-3,-1, 0, 0, 0}},
/*TUohm*/ {"ohm",    "ohm",     1.0,     { 2, 1,-3,-2, 0, 0, 0}},
/*TUS*/   {"S",      "siemens", 1.0,     {-2,-1, 3, 2, 0, 0, 0}},
/*TUF*/   {"F",      "farad",   1.0,     {-2,-1, 4, 2, 0, 0, 0}},
/*TUT*/   {"T",      "tesla",   1.0,     { 0, 1,-2,-1, 0, 0, 0}},
/*TUWb*/  {"Wb",     "weber",   1.0,     { 2, 1,-2,-1, 0, 0, 0}},
/*TUH*/   {"H",      "henry",   1.0,     { 2, 1,-2,-2, 0, 0, 0}},
/*TUlm*/  {"lm",     "lumen",   1.0,     { 0, 0, 0, 0, 0, 0, 1}},
/*TUlx*/  {"lx",     "lux",     1.0,     {-2, 0, 0, 0, 0, 0, 1}},
};

int significative(char* text);
int significative(char* text){
  // returns the number of significative digits of a decimal
  // considers separately the case when a number is zero
  int i,j,result=0;
  char *end = text+strlen(text);
  while (end>text && *(end-1)==' '){ // removes the rightmost spaces
    end--;
    *end=0;
  }
  for(i=0;
      i<strlen(text)&&(text[i]=='0'||text[i]=='.'|| text[i]=='+'||text[i]=='-');
      i++){
    //skip leading plus,minus,zeros and the decimal point
  }
  if (i==strlen(text)){ // the number is probably zero
    result=1;
    char * dot = strchr(text,'.');
    if (dot != NULL && *dot == '.') result += (end-dot)-1;
  } else { // the number is not zero
    for(j=i;j<strlen(text)&&(text[j]>='0'&&text[j]<='9'||text[j]=='.');j++){
      if (text[j]!='.') {
	result++;
      } else {
	//skip the decimal point
      }
    }
  }
  return result;
}



/* Line 189 of yacc.c  */
#line 257 "unitesparser.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     EE = 258,
     DECIMAL = 259,
     INT = 260,
     SPC = 261,
     COLON = 262,
     Uh = 263,
     Umin = 264,
     Um = 265,
     Ug = 266,
     Us = 267,
     UA = 268,
     UK = 269,
     Umol = 270,
     Ucd = 271,
     UHz = 272,
     UN = 273,
     UPa = 274,
     UJ = 275,
     UW = 276,
     UC = 277,
     UV = 278,
     Uohm = 279,
     US = 280,
     UF = 281,
     UT = 282,
     UWb = 283,
     UH = 284,
     Ulm = 285,
     Ulx = 286,
     UBq = 287,
     UGy = 288,
     USv = 289,
     Urad = 290,
     Usr = 291,
     PUIS = 292,
     PP = 293,
     POINT = 294,
     BARRE = 295,
     Uda = 296,
     Uma = 297,
     Usa = 298,
     Uangs = 299,
     Ubarn = 300,
     Uare = 301,
     Ul = 302,
     Ut = 303,
     Ubar = 304,
     UeV = 305,
     Uuam = 306,
     Signif = 307,
     PlusminPC = 308
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 352 "unitesparser.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  10
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   141

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  54
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  16
/* YYNRULES -- Number of rules.  */
#define YYNRULES  73
/* YYNRULES -- Number of states.  */
#define YYNSTATES  86

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   308

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint8 yyprhs[] =
{
       0,     0,     3,     5,     7,    11,    13,    17,    19,    23,
      28,    33,    35,    38,    41,    42,    44,    47,    49,    52,
      55,    57,    60,    63,    66,    69,    71,    74,    75,    77,
      79,    81,    85,    89,    91,    93,    95,    97,    99,   101,
     103,   105,   107,   109,   111,   113,   115,   117,   119,   121,
     123,   125,   127,   129,   131,   133,   135,   137,   139,   141,
     143,   145,   147,   149,   151,   153,   155,   157,   159,   161,
     163,   165,   167,   169
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      55,     0,    -1,    56,    -1,    59,    -1,    58,    60,    56,
      -1,    58,    -1,    58,     7,    57,    -1,    61,    -1,    67,
      60,    61,    -1,    67,    60,    61,    52,    -1,    67,    60,
      61,    53,    -1,    67,    -1,    67,    52,    -1,    67,    53,
      -1,    -1,     6,    -1,    61,    62,    -1,    65,    -1,    63,
      65,    -1,    40,    65,    -1,    39,    -1,    10,    69,    -1,
      27,    69,    -1,     8,    69,    -1,    68,    69,    -1,    69,
      -1,    64,    66,    -1,    -1,    37,    -1,     5,    -1,     4,
      -1,     4,     3,     5,    -1,     5,     3,     5,    -1,    38,
      -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,    12,
      -1,    13,    -1,    14,    -1,    15,    -1,    16,    -1,    17,
      -1,    18,    -1,    19,    -1,    20,    -1,    27,    -1,    21,
      -1,    22,    -1,    23,    -1,    24,    -1,    25,    -1,    26,
      -1,    28,    -1,    29,    -1,    30,    -1,    31,    -1,    32,
      -1,    33,    -1,    34,    -1,    35,    -1,    36,    -1,    41,
      -1,    42,    -1,    43,    -1,    44,    -1,    45,    -1,    46,
      -1,    47,    -1,    48,    -1,    49,    -1,    50,    -1,    51,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   241,   241,   242,   245,   255,   256,   267,   270,   271,
     275,   281,   290,   298,   308,   309,   312,   324,   327,   333,
     347,   351,   358,   365,   372,   379,   384,   412,   413,   416,
     417,   418,   419,   423,   448,   449,   450,   451,   452,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,   485,   486,   487
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "EE", "DECIMAL", "INT", "SPC", "COLON",
  "Uh", "Umin", "Um", "Ug", "Us", "UA", "UK", "Umol", "Ucd", "UHz", "UN",
  "UPa", "UJ", "UW", "UC", "UV", "Uohm", "US", "UF", "UT", "UWb", "UH",
  "Ulm", "Ulx", "UBq", "UGy", "USv", "Urad", "Usr", "PUIS", "PP", "POINT",
  "BARRE", "Uda", "Uma", "Usa", "Uangs", "Ubarn", "Uare", "Ul", "Ut",
  "Ubar", "UeV", "Uuam", "Signif", "PlusminPC", "$accept", "but",
  "valeur_mixte", "style", "valeur", "sans_unite", "spc", "unite",
  "suiv_unit", "point", "prim_unit1", "prim_unit", "puissance01",
  "decimal", "prefixe", "base_unite", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    54,    55,    55,    56,    56,    56,    57,    58,    58,
      58,    59,    59,    59,    60,    60,    61,    61,    62,    62,
      63,    64,    64,    64,    64,    64,    65,    66,    66,    67,
      67,    67,    67,    68,    69,    69,    69,    69,    69,    69,
      69,    69,    69,    69,    69,    69,    69,    69,    69,    69,
      69,    69,    69,    69,    69,    69,    69,    69,    69,    69,
      69,    69,    69,    69,    69,    69,    69,    69,    69,    69,
      69,    69,    69,    69
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     3,     1,     3,     1,     3,     4,
       4,     1,     2,     2,     0,     1,     2,     1,     2,     2,
       1,     2,     2,     2,     2,     1,     2,     0,     1,     1,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,    30,    29,     0,     2,    14,     3,    14,     0,     0,
       1,    15,     0,     0,    12,    13,     0,    31,    32,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    48,    49,    50,    51,    52,    53,    47,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    33,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
       6,     7,    27,    17,     0,    25,     4,    14,     8,    34,
      36,    47,    23,    21,    22,    20,     0,    16,     0,    28,
      26,    24,     9,    10,    19,    18
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     3,     4,    60,     5,     6,    16,    61,    77,    78,
      62,    63,    80,     7,    64,    65
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -67
static const yytype_int8 yypact[] =
{
       9,     4,     8,    19,   -67,     2,   -67,     0,    16,    17,
     -67,   -67,    46,     9,   -67,   -67,    46,   -67,   -67,    90,
     -67,    90,   -67,   -67,   -67,   -67,   -67,   -67,   -67,   -67,
     -67,   -67,   -67,   -67,   -67,   -67,   -67,   -67,    90,   -67,
     -67,   -67,   -67,   -67,   -67,   -67,   -67,   -67,   -67,   -67,
     -67,   -67,   -67,   -67,   -67,   -67,   -67,   -67,   -67,   -67,
     -67,   -24,   -14,   -67,    90,   -67,   -67,    18,   -35,   -67,
     -67,   -67,   -67,   -67,   -67,   -67,    46,   -67,    46,   -67,
     -67,   -67,   -67,   -67,   -67,   -67
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -67,   -67,    12,   -67,   -67,   -67,    21,    11,   -67,   -67,
     -67,   -66,   -67,    15,   -67,   -18
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -12
static const yytype_int8 yytable[] =
{
     -11,    72,    -5,    73,    75,    76,    11,     8,    11,    12,
      84,     9,    85,     1,     2,    75,    76,    82,    83,    10,
      74,    17,    18,    79,    11,    66,    13,    68,    67,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,     0,     0,     0,
       0,     0,    14,    15,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,     0,    48,     0,     0,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    69,    20,
      70,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    71,    39,    40,
      41,    42,    43,    44,    45,    46,    47,     0,     0,     0,
       0,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59
};

static const yytype_int8 yycheck[] =
{
       0,    19,     0,    21,    39,    40,     6,     3,     6,     7,
      76,     3,    78,     4,     5,    39,    40,    52,    53,     0,
      38,     5,     5,    37,     6,    13,     5,    16,    13,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    64,    -1,    -1,    -1,
      -1,    -1,    52,    53,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    -1,    38,    -1,    -1,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    -1,
      -1,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     4,     5,    55,    56,    58,    59,    67,     3,     3,
       0,     6,     7,    60,    52,    53,    60,     5,     5,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    38,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      57,    61,    64,    65,    68,    69,    56,    67,    61,     8,
      10,    27,    69,    69,    69,    39,    40,    62,    63,    37,
      66,    69,    52,    53,    65,    65
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{


    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1455 of yacc.c  */
#line 241 "unites.y"
    {result = (yyvsp[(1) - (1)]);;}
    break;

  case 3:

/* Line 1455 of yacc.c  */
#line 242 "unites.y"
    {result = (yyvsp[(1) - (1)]);;}
    break;

  case 4:

/* Line 1455 of yacc.c  */
#line 245 "unites.y"
    {
  int i;
  for(i=0; i < BU_LAST; i++){
    if ((yyvsp[(1) - (3)]).base[i] != (yyvsp[(3) - (3)]).base[i]) yyerror ("not homogeneous units");
  }
  if ((yyvsp[(1) - (3)]).multip <= (yyvsp[(3) - (3)]).maxmultip) yyerror ("incorrect mutiple units ordering");
  (yyval).val=(yyvsp[(1) - (3)]).val*(yyvsp[(1) - (3)]).multip+(yyvsp[(3) - (3)]).val*(yyvsp[(3) - (3)]).multip;
  (yyval).multip=1; (yyval).maxmultip = (yyvsp[(1) - (3)]).multip;
  (yyval).wanted_unit="";
;}
    break;

  case 5:

/* Line 1455 of yacc.c  */
#line 255 "unites.y"
    {(yyval)=(yyvsp[(1) - (1)]); (yyval).maxmultip=(yyvsp[(1) - (1)]).multip;(yyval).wanted_unit="";;}
    break;

  case 6:

/* Line 1455 of yacc.c  */
#line 256 "unites.y"
    {
  int i;
  (yyval)=(yyvsp[(1) - (3)]); (yyval).maxmultip=(yyvsp[(1) - (3)]).multip;
  for(i=0; i < BU_LAST; i++){
    if ((yyvsp[(1) - (3)]).base[i] != (yyvsp[(3) - (3)]).base[i]) yyerror ("wanted unit not homogeneous");
  }  
  (yyval).wanted_multip=(yyvsp[(3) - (3)]).multip;
  (yyval).wanted_unit=(yyvsp[(3) - (3)]).s;
;}
    break;

  case 7:

/* Line 1455 of yacc.c  */
#line 267 "unites.y"
    {(yyval)=(yyvsp[(1) - (1)]);;}
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 270 "unites.y"
    {(yyval)=(yyvsp[(3) - (3)]); (yyval).val=val_decimal; (yyval).signif=0; (yyval).pcent=0;;}
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 271 "unites.y"
    {
  (yyval)=(yyvsp[(3) - (4)]); (yyval).val=val_decimal; 
  (yyval).signif=val_int; (yyval).pcent=0;
;}
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 275 "unites.y"
    {
  (yyval)=(yyvsp[(3) - (4)]); (yyval).val=val_decimal; 
  (yyval).pcent=val_int; (yyval).signif=0;
;}
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 281 "unites.y"
    {
  int i;
  (yyval)=(yyvsp[(1) - (1)]);
  (yyval).val=val_decimal; 
  for (i=0; i < BU_LAST; i++){(yyval).base[i]=unites[TUnull].base[i];} 
  (yyval).multip=1.0; 
  (yyval).signif=0; (yyval).pcent=0;
  (yyval).wanted_unit="";
;}
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 290 "unites.y"
    {
  int i;
  (yyval)=(yyvsp[(1) - (2)]);
  (yyval).val=val_decimal; 
  for (i=0; i < BU_LAST; i++){(yyval).base[i]=unites[TUnull].base[i];} 
  (yyval).multip=1.0; 
  (yyval).signif=val_int; (yyval).pcent=0;
;}
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 298 "unites.y"
    {
  int i;
  (yyval)=(yyvsp[(1) - (2)]);
  (yyval).val=val_decimal; 
  for (i=0; i < BU_LAST; i++){(yyval).base[i]=unites[TUnull].base[i];} 
  (yyval).multip=1.0; 
  (yyval).signif=0; (yyval).pcent=val_int;
;}
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 312 "unites.y"
    {
  int index;
  (yyval).unite = TU_LAST; /* unit non renseigne */
  strncpy(buffer,(yyvsp[(1) - (2)]).s,MAXBUF); 
  strncat(buffer,(yyvsp[(2) - (2)]).s,MAXBUF-strlen((yyvsp[(1) - (2)]).s)); 
  free((yyvsp[(1) - (2)]).s); free((yyvsp[(2) - (2)]).s);
  (yyval).s=strdup(buffer);
  for(index=0; index< BU_LAST; index++){
    (yyval).base[index] = (yyvsp[(1) - (2)]).base[index]+(yyvsp[(2) - (2)]).base[index] ; 
  }
  (yyval).multip = (yyvsp[(1) - (2)]).multip*(yyvsp[(2) - (2)]).multip;
;}
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 324 "unites.y"
    { (yyval)=(yyvsp[(1) - (1)]); ;}
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 327 "unites.y"
    {
  (yyval)=(yyvsp[(2) - (2)]); strncpy(buffer,".",MAXBUF); 
  strncat(buffer,(yyvsp[(2) - (2)]).s,MAXBUF-1); 
  free((yyvsp[(2) - (2)]).s);
  (yyval).s=strdup(buffer);
;}
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 333 "unites.y"
    {
  int index;
  (yyval)=(yyvsp[(2) - (2)]); 
  (yyval).multip = 1/ (yyval).multip;
  strncpy(buffer,"/",MAXBUF); 
  strncat(buffer,(yyvsp[(2) - (2)]).s,MAXBUF-1); 
  free((yyvsp[(2) - (2)]).s);
  (yyval).s=strdup(buffer);
  for(index=0; index< BU_LAST; index++){
    (yyval).base[index] *= -1; 
  }
;}
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 351 "unites.y"
    {
  (yyval)=(yyvsp[(2) - (2)]);
  strncpy(buffer,"m",MAXBUF); 
  strncat(buffer,(yyvsp[(2) - (2)]).s,MAXBUF-1); 
  free((yyvsp[(2) - (2)]).s);
  (yyval).s = strdup(buffer); (yyval).multip*=1e-3; 
;}
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 358 "unites.y"
    {
  (yyval)=(yyvsp[(2) - (2)]);
  strncpy(buffer,"T",MAXBUF); 
  strncat(buffer,(yyvsp[(2) - (2)]).s,MAXBUF-1); 
  free((yyvsp[(2) - (2)]).s);
  (yyval).s = strdup(buffer); (yyval).multip*=1e12;
;}
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 365 "unites.y"
    {
  (yyval)=(yyvsp[(2) - (2)]);
  strncpy(buffer,"h",MAXBUF); 
  strncat(buffer,(yyvsp[(2) - (2)]).s,MAXBUF-1); 
  free((yyvsp[(2) - (2)]).s);
  (yyval).s = strdup(buffer); (yyval).multip*=1e2;
;}
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 372 "unites.y"
    {
  (yyval)=(yyvsp[(2) - (2)]);
  strncpy(buffer, (yyvsp[(1) - (2)]).s,MAXBUF); 
  strncat(buffer, (yyvsp[(2) - (2)]).s, MAXBUF-strlen((yyvsp[(1) - (2)]).s));
  free((yyvsp[(1) - (2)]).s); free((yyvsp[(2) - (2)]).s);(yyval).s=strdup(buffer); 
  (yyval).multip*=(yyvsp[(1) - (2)]).multip;
  ;}
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 379 "unites.y"
    {
  (yyval)=(yyvsp[(1) - (1)]);
;}
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 384 "unites.y"
    {
  int index;
  mpq_class r;

  (yyval).i=(yyvsp[(2) - (2)]).i;
  strncpy(buffer, (yyvsp[(1) - (2)]).s,MAXBUF);
  if ((yyvsp[(2) - (2)]).i!=1){
    strncat(buffer, "^%d",MAXBUF-strlen((yyvsp[(1) - (2)]).s)); 
    sprintf(buffer2, buffer, (yyvsp[(2) - (2)]).i);
  }
  else strncpy(buffer2,buffer,MAXBUF);
  (yyval).s=strdup(buffer2); free((yyvsp[(1) - (2)]).s);
  for(index=0; index< BU_LAST; index++){
    (yyval).base[index] = unites[(yyvsp[(1) - (2)]).unite].base[index]*(yyvsp[(2) - (2)]).i;
  }
  if ((yyvsp[(2) - (2)]).i>0){
    for(index=0, r=1; index<(yyvsp[(2) - (2)]).i ; index++){
      r*= (yyval).multip;
    }
  } else {
    for(index=0, r=1; index>(yyvsp[(2) - (2)]).i ; index--){
      r /= (yyval).multip;
    }
  }
  (yyval).multip=r;
;}
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 412 "unites.y"
    {(yyval).i=1;;}
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 413 "unites.y"
    {(yyval).i = val_int;;}
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 416 "unites.y"
    {(yyval).val=val_decimal;;}
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 417 "unites.y"
    {(yyval).val=val_decimal;;}
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 418 "unites.y"
    {atodecimal((yyvsp[(1) - (3)]).v,val_decimal); int e = atoi((yyvsp[(3) - (3)]).v); if (e>0) for (int i=0; i<e;i++) val_decimal *=10; if (e<0) for (int i=0; i<-e;i++) val_decimal /=10; (yyval).val=val_decimal;}
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 419 "unites.y"
    {val_decimal=atoi((yyvsp[(1) - (3)]).v); int e = atoi((yyvsp[(3) - (3)]).v); if (e>0) for (int i=0; i<e;i++) val_decimal *=10; if (e<0) for (int i=0; i<-e;i++) val_decimal /=10; (yyval).val=val_decimal;}
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 423 "unites.y"
    {(yyval).multip=1.0; char c=(yyval).s[0]; 
 switch (c){
 case 'y' : (yyval).multip = 1e-24; break;
 case 'z' : (yyval).multip = 1e-21; break;
 case 'a' : (yyval).multip = 1e-18; break;
 case 'f' : (yyval).multip = 1e-15; break;
 case 'p' : (yyval).multip = 1e-12; break;
 case 'n' : (yyval).multip = 1e-9; break;
 case '' : (yyval).multip = 1e-6; break;
 case 'c' : (yyval).multip = 1e-2; break;
 case 'd' : if (!strcmp ((yyval).s,"da") ) (yyval).multip = 10.0;
    else (yyval).multip = 0.1; break;
 case 'h' : (yyval).multip = 1e2; break;
 case 'k' : (yyval).multip = 1e3; break;
 case 'M' : (yyval).multip = 1e6; break;
 case 'G' : (yyval).multip = 1e9; break;
 case 'P' : (yyval).multip = 1e15; break;
 case 'E' : (yyval).multip = 1e18; break;
 case 'Z' : (yyval).multip = 1e21; break;
 case 'Y': (yyval).multip = 1e24; break;
 }
;}
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 448 "unites.y"
    {(yyval).unite=TUh; (yyval).s = strdup("h"); (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 449 "unites.y"
    {(yyval).unite=TUmin;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 450 "unites.y"
    {(yyval).unite=TUm; (yyval).s = strdup("m"); (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 451 "unites.y"
    {(yyval).unite=TUg;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 452 "unites.y"
    {(yyval).unite=TUs;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 453 "unites.y"
    { (yyval).unite = TUA;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 40:

/* Line 1455 of yacc.c  */
#line 454 "unites.y"
    { (yyval).unite = TUK;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 455 "unites.y"
    { (yyval).unite = TUmol;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 456 "unites.y"
    { (yyval).unite = TUcd;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 457 "unites.y"
    { (yyval).unite = TUHz;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 458 "unites.y"
    { (yyval).unite = TUN;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 459 "unites.y"
    { (yyval).unite = TUPa;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 460 "unites.y"
    { (yyval).unite = TUJ;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 47:

/* Line 1455 of yacc.c  */
#line 461 "unites.y"
    { (yyval).unite = TUT; (yyval).s = strdup("T"); (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 462 "unites.y"
    { (yyval).unite = TUW;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 463 "unites.y"
    { (yyval).unite = TUC;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 464 "unites.y"
    { (yyval).unite = TUV;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 465 "unites.y"
    { (yyval).unite = TUohm;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 466 "unites.y"
    { (yyval).unite = TUS;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 467 "unites.y"
    { (yyval).unite = TUF;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 468 "unites.y"
    { (yyval).unite = TUWb;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 469 "unites.y"
    { (yyval).unite = TUH;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 470 "unites.y"
    { (yyval).unite = TUlm;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 471 "unites.y"
    { (yyval).unite = TUlx;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 472 "unites.y"
    { (yyval).unite = TUBq;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 473 "unites.y"
    { (yyval).unite = TUGy;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 474 "unites.y"
    { (yyval).unite = TUSv;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 475 "unites.y"
    { (yyval).unite = TUrad;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 476 "unites.y"
    { (yyval).unite = TUsr;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 477 "unites.y"
    { (yyval).unite = TUda;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 478 "unites.y"
    { (yyval).unite = TUma;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 479 "unites.y"
    { (yyval).unite = TUsa;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 480 "unites.y"
    { (yyval).unite = TUangs;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 67:

/* Line 1455 of yacc.c  */
#line 481 "unites.y"
    { (yyval).unite = TUbarn;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 482 "unites.y"
    { (yyval).unite = TUare;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 483 "unites.y"
    { (yyval).unite = TUl;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 484 "unites.y"
    { (yyval).unite = TUt;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 485 "unites.y"
    { (yyval).unite = TUbar;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 72:

/* Line 1455 of yacc.c  */
#line 486 "unites.y"
    { (yyval).unite = TUeV;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;

  case 73:

/* Line 1455 of yacc.c  */
#line 487 "unites.y"
    { (yyval).unite = TUuam;  (yyval).multip=unites[(yyval).unite].multiplicateur;;}
    break;



/* Line 1455 of yacc.c  */
#line 2272 "unitesparser.cc"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 1675 of yacc.c  */
#line 492 "unites.y"


#include "uniteslex.cc"
#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>

#ifdef RECODE_SUPPORT
  #include <recode.h>
#endif

#include <regex.h>

const char *program_name;
int isUTF8;

/* le programme lui-mme */

typedef enum {option_default, option_s, option_o, option_l} optiontype;

yyFlexLexer lexer;
yyFlexLexer * thelexer = &lexer;

int yylex(){
  return thelexer->yylex();
}


inline int yyerror(const char * msg){
  printf("ERROR at %ld : %s\n", pos, msg);
  exit(1);
}

void test_verbeux(){
  int i;
  yyparse();
  if (result.s) {
    if (result.unite == TU_LAST){
      std::cout << result.s << " " << result.multip*result.val << " SI (quation aux dimensions : ";
      for (i=0; i<BU_LAST; i++){
	printf("%3d", result.base[i]);
      }
      printf(")\n");
    }
    else {
      if (result.i!=1) 
	std::cout <<  result.s << " (" << result.multip*result.val 
		  << " " << unites[result.unite].nom << ")^{" << result.i 
		  << "}\n";
      else 
	std::cout << result.s << " " << result.multip*result.val 
		  << " " << unites[result.unite].nom << "\n";
    }
  }
  else fprintf(stderr, "problme : result.s = null\n");
}

void sortie_normalisee(){
  /***************************************************/
  /* le format des donnes en sortie est :           */
  /* double int int int int int int int              */
  /* et signifie  dans l'ordre                       */
  /***************************************************/
  /* valeur                                          */
  /* puissance en unit de longueur (m)              */
  /* puissance en unit de masse (kg)                */
  /* puissance en unit de temps (s)                 */
  /* puissance en unit de courant (A)               */
  /* puissance en unit de temprature (K)           */
  /* puissance en unit de quantit de matire (mol) */
  /* puissance en unit de inutensit lumineuse (cd) */
  /* nombre de chiffres significatifs                */
  /* tolrance (en pourcentage)                      */
  /***************************************************/
  int i,s=0,pc=0;

  yyparse();
  // il faut afficher le rsultat sous forme d'un nombre dcimal et pas d'une
  // fraction
  //std::cout << result.multip*result.val;
  std::cout << mpf_class(result.multip*result.val);
  if (count_signif){ //il faut prendre en compte les nombres significatifs
    if (!result.signif) {
      s=significative(result.v);
    } else {
      s=result.signif;
    }
  }
  pc=result.pcent;
  for (i=0; i<BU_LAST; i++){
    printf(" %3d", result.base[i]);
  }
  printf("    %d    %d\n",s,pc);
}

void printUnit(optiontype option, std::string unit, int tolerance){
  char * indexohm;
  char buffer[128];
  char *codedunit;

#ifdef RECODE_SUPPORT
  if(isUTF8) {
    RECODE_OUTER outer = recode_new_outer (true);
    RECODE_REQUEST request = recode_new_request (outer);
    recode_scan_request (request, "latin1..utf8"); 
    codedunit=strdup(recode_string(request,unit.c_str()));
  } else {
    codedunit=strdup(unit.c_str());
  }
#else
  codedunit=strdup(unit.c_str());
#endif

  if (option==option_l){
    strncpy(buffer, codedunit,sizeof(buffer));
    indexohm=strstr(buffer,"ohm");
    if (indexohm){
      strncpy(indexohm, "\\Omega", sizeof(buffer)-strlen("\\Omega")+strlen("ohm"));
    }
    printf(" %s",buffer);
  } else {
    printf(" %s",codedunit);
  }
  if (tolerance){
    if (option==option_l){
      printf(" \\pm %d\\,\\%%",tolerance);
    } else{
      printf(" +-%d%%",tolerance);
    }
  }
  printf("\n");
  free(codedunit);
}

mpq_class round_mpc(const mpq_class & x);

void printValue(optiontype option, yystype result, int s){
  char val[128],exp[128], *i, *j, *indexE;
  char buf[128];
  regex_t regex;
  regmatch_t matches[3];
  int success,l;
  int vallen;

  mpq_class value=result.multip*result.val;
  if (value==0){
    printf("0");
    if (s>1){
      printf(".");
      for (int i=1; i<s; i++){
	printf("0");
      }
    }
    return;
  }
  mpq_class absval=abs(value);
  mpq_class powten=1;
  while(absval >=10){powten*=10; absval/=10;}
  while(absval < 1) {powten/=10; absval*=10;}
  for (int i=1;i<s;i++) powten/=10;
  mpz_class r=round_mpc(value/powten);
  value=r*powten;
  if (s<=1){ 
    snprintf(buf,sizeof(buf),"%1.0e", value.get_d() );
  } else {
    snprintf(buf,sizeof(buf),"%1.*e", s-1,value.get_d() );
  }
  // simplifications
  regcomp(&regex, "^(.*)(e[+-][0-9]+)$", REG_EXTENDED);
  regexec(&regex, buf, 3, matches,0);
  if (strcmp(buf+matches[2].rm_so,"e+00")==0) {
    // removing e+00
    *(buf+matches[2].rm_so)=0;
  }
  l=strlen(buf);
  if (*(buf+matches[2].rm_so+1)=='+'){
    j=buf+matches[2].rm_so+2;
    while (*j=='0') j++;
    for(i=buf+matches[2].rm_so+1; j<=buf+l; i++,j++){
      // erasing +0* after e
      *i=*j;
    }
  }
  if (*(buf+matches[2].rm_so+1)=='-'){
    j=buf+matches[2].rm_so+2;
    while (*j=='0') j++;
    for(i=buf+matches[2].rm_so+2; j<=buf+l; i++,j++){
      // erasing 0* after e-
      *i=*j;
    }
  }
  if (option==option_l){
    indexE=strstr(buf,"e");
    if (indexE){
      vallen=indexE-buf;
      strncpy(val,buf,vallen);
      val[vallen]=0;
      strncpy(exp,indexE+1,sizeof(exp));
      printf("%s\\cdot 10^{%s}\\,",val,exp);
    } else{
      printf("%s\\,",buf);
    }
  } else {
    printf(buf);
  }
}

double trunc(double x);

mpq_class round_mpc(const mpq_class & x){
  /**
   * computes a rounded multiprecision integer from the input data
   * this may be valid only for positive inputs.
   * @param x the input data
   * @result the rouded value : 1499999/1000000 is rounded towards 1
   * and 3/2 is rounded towards 2
   */
  mpq_class halfUnit=mpq_class(1,2);
  mpq_class y;
  if (x>0){ y = x+halfUnit;} else { y = x-halfUnit;}
  mpz_class q=y.get_num()/y.get_den();
  return q;
}


void sortie_texte(optiontype option){
  /***************************************************/
  /* le format des donnes en sortie est :           */
  /* double string                                   */
  /* et signifie  dans l'ordre                       */
  /***************************************************/
  /* valeur (compte tenu des chiffres significatifs) */
  /* unit   (SI)  +- pcent %                        */
  /***************************************************/
  int i,j,
    s=0,pc=0,
    notfirst=0,
    trouve=0,
    nb_pref=sizeof(pref_units)/sizeof(pref_units[0]);
  //mpq_class val, r, powten, absval; /* val r powten and absval are multiprecision rationals */
  int puisdix;

  yyparse();
  if (!result.signif) {
    s=significative(result.v);
    /* le nombre de chiffres significatifs est dduit de la valeur donne */
  } else {
    s=result.signif;
    /* le nombre de chiffres significatifs a t explicit */
  }
  pc=result.pcent;
  // arrondit en tenant compte du nombre de chiffres significatifs
  if (result.wanted_unit.length()>0){
    result.multip /= result.wanted_multip;
  }else{ // met le multiplicateur  1 si l'unit d'entre a t repre
    if (result.s && strlen(result.s)>0){
      result.multip = mpq_class(1,1);
    }
  }
  printValue(option, result, s);
  // affiche l'unit SI.
  // renvoie l'unit demande si elle existe
  if (result.wanted_unit.length()>0){
    printUnit(option, result.wanted_unit, pc);
    return;
  }
  // affiche l'unit donne  l'entre par dfaut
  if (result.s && strlen(result.s)>0){
    printUnit(option, result.s, pc);
    return;
  }
  // recherche s'il y a une unit prfrentielle
  for (i=0; i<nb_pref; i++){
    trouve=(result.base[0]==pref_units[i].base[0]);
    for (j=1; j<BU_LAST; j++){
      trouve &= (result.base[j]==pref_units[i].base[j]);
    }
    if (trouve){
      printUnit(option, pref_units[i].sym, pc);
      return;
    }
  }
  // on teste s'il y aura une unit visible
  int visible_unit=0;
  for (i=0; i<BU_LAST; i++){
    if (result.base[i]!=0) visible_unit=1;
  }
  if (result.wanted_unit.length()>0) visible_unit=1;
  if(visible_unit!=0){ // on ne marque les units que s'il y en a !
    for (i=0; i<BU_LAST; i++){
      if (result.base[i]!=0){
	if (notfirst) printf("."); else printf(" ");
	printf("%s",unit_names[i]);
	notfirst=1;
	if (result.base[i]!=1){
	  if (option==option_l){
	    printf("^{%d}",result.base[i]);
	  } else {
	    printf("^%d",result.base[i]);
	  }
	}
      }
    }
    printUnit(option, "", pc);
  }
}

int main(int argc, char * argv[]){
  const char * optstr = "osl";
  char * envoption=getenv("units_option");
  // environmental option take precedence on command-line options

  optiontype option=option_default;
  
  int ch;
  while (-1 != (ch=getopt(argc,argv,optstr))){
    switch(ch){
    case 's': 
      option=option_s;
      break;
    case 'o':
      option=option_o;
      break;
    case 'l':
      option=option_l;
      break;
    default: 
      break;
    }
  }
  if (envoption && strncmp(envoption, "s", 2)==0) option=option_s;
  if (envoption && strncmp(envoption, "o", 2)==0) option=option_o;
  if (envoption && strncmp(envoption, "l", 2)==0) option=option_l;
#ifdef RECODE_SUPPORT
  // check if we are in a UTF8 environment
  char *lc_all=getenv("LC_ALL");
  isUTF8 = (lc_all!= NULL && strstr(lc_all,"UTF-8"));
#endif
  program_name = argv[0];

  // environmental option take precedence on command-line options
  switch(option){
  case option_s: 
    count_signif=1;
    sortie_normalisee();
    return 0;
    break;
  case option_o:
  case option_l:
    sortie_texte(option);
    return 0;
    break;
  default: 
    break;
  }
  /*test_verbeux();*/
  sortie_normalisee();
  return 0;
}

void atodecimal(char* s, mpq_class & r){
  /**
   * ascii to fraction
   * @param s : a string which denotes a decimal value
   * @param r : the result which is the fraction.
   */
  char * numer= strdup(s);
  char * theDot=index(numer,'.');
  if (theDot==NULL){
    r=mpq_class(atoi(s),1);
  } else {
    int denom=1;
    int expon=0, numerExp=1;
    while(theDot<numer+strlen(numer)){
      *theDot = *(theDot+1);
      theDot+=1;
      switch (*theDot){
      case 0: break;
      case 'e':
      case 'E': expon=atoi(theDot+1); *theDot=0; break;
      default: denom*=10;
      }
    }
    if (expon>0) for(int i=0; i<expon;  i++) numerExp*=10;
    if (expon<0) for(int i=0; i<-expon; i++) denom*=10;
    r=mpq_class(atoi(numer)*numerExp,denom);
  }
  free(numer);
  return;
}

