/***************************************************************************
                                 register.cpp
                              -------------------

     Begin        : Mon Nov 10 2008 13:20 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : For interact with windows and the dll

****************************************************************************/

#include <QString>
#include <QStringList>
#include <QProcess>

#include "env.h"

#if defined (Q_OS_WIN32) || defined (Q_OS_WINCE)

#include <windows.h>
#include <tlhelp32.h>

bool WINAPI DLLEjecteurW(DWORD dwPid,PWSTR szDLLPath)
{
	/* Search address of module */
	MODULEENTRY32W meModule;
	meModule.dwSize = sizeof(meModule);
	HANDLE hSnapshot = NULL;
	
	hSnapshot = CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwPid);
	if(hSnapshot == NULL)
		return false;
	
	/* Search the right modules of the process */
	Module32FirstW(hSnapshot, &meModule);
	do{
		if((lstrcmpiW(meModule.szModule,szDLLPath) == 0) || (lstrcmpiW(meModule.szExePath,szDLLPath) == 0))break;
	}while(Module32NextW(hSnapshot, &meModule));
	
	/* Get handle of the process */
	HANDLE hProcess;
	
	hProcess = OpenProcess(PROCESS_ALL_ACCESS, false,dwPid);
	if(hProcess == NULL)
	{
		CloseHandle(hSnapshot);
		return false;
	}
	
	LPTHREAD_START_ROUTINE lpthThreadFunction;
	/* Get addresse of FreeLibrary in kernel32.dll */
	lpthThreadFunction = (LPTHREAD_START_ROUTINE)GetProcAddress(GetModuleHandle(L"kernel32.dll"), "FreeLibrary");
	if(lpthThreadFunction == NULL)
	{
		CloseHandle(hProcess);
		CloseHandle(hSnapshot);
		return false;
	}	
	
	/* Creation the remote thread */
	DWORD dwThreadID = 0;
	HANDLE hThread = NULL;
	hThread = CreateRemoteThread(hProcess, NULL, 0, lpthThreadFunction,meModule.modBaseAddr, 0, &dwThreadID);
	if(hThread == NULL)
	{
		CloseHandle(hSnapshot);
		CloseHandle(hProcess);
		return false;
	}
	
	WaitForSingleObject(hThread,INFINITE);
	
	CloseHandle(hProcess);
	CloseHandle(hThread);
	
	return true;
}

void HardUnloadDLL(QString myDllName)
{
	//QFile theDllFile(myDllName);
	//myDllName=theDllFile.fileName();
	DEBUGCONSOLE(90,"HardUnloadDLL","start");
	HANDLE hSnapShot1;
	PROCESSENTRY32 uProcess;
	HANDLE hSnapShot2;
	MODULEENTRY32 me32;
	QString DllLoaded = "";
	QString DllLoadedName = "";
	QString DllLoadedPath = "";
	bool bResult;
	bool r;
	short NbProcess;
	NbProcess=0;

	hSnapShot1 = CreateToolhelp32Snapshot(TH32CS_SNAPALL,0);

	uProcess.dwSize = (DWORD) sizeof(PROCESSENTRY32);

	r = Process32First(hSnapShot1, &uProcess);

	while ( r )
	{
		r = Process32Next(hSnapShot1, &uProcess);
		QString myProcessName;
		myProcessName=QString::fromWCharArray(uProcess.szExeFile);
		if (uProcess.th32ProcessID < 99999)
		{
			hSnapShot2 = CreateToolhelp32Snapshot( TH32CS_SNAPMODULE, uProcess.th32ProcessID );
			if (hSnapShot2 != INVALID_HANDLE_VALUE)
			{
				me32.dwSize = sizeof(me32);
				bResult = Module32First( hSnapShot2, &me32 );
				while( bResult )
				{
						DllLoaded=QString::fromWCharArray(me32.szExePath);
						DllLoadedName=QString::fromWCharArray(me32.szModule);
						if (DllLoaded == myDllName)
						{
							DEBUGCONSOLE(90,"RegisterShellExtDll","The path: "+DllLoaded);
							DEBUGCONSOLE(90,"RegisterShellExtDll",myProcessName+" ("+QString::number(uProcess.th32ProcessID)+")");
							DLLEjecteurW(uProcess.th32ProcessID,me32.szExePath);
						}
						bResult = Module32Next( hSnapShot2, &me32 );
				}
			}
			else
			{
				//DEBUGCONSOLE(90,"HardUnloadDLL","(int)hSnapShot2 != -1 for "+myProcessName+" ("+QString::number(uProcess.th32ProcessID)+")");
			}
			if(hSnapShot2)
				CloseHandle(hSnapShot2);
		}
		else
		{
			DEBUGCONSOLE(90,"HardUnloadDLL","uProcess.th32ProcessID > 99999 for "+myProcessName+" ("+QString::number(uProcess.th32ProcessID)+")");
		}
	}
	CloseHandle(hSnapShot1);
}

bool RegisterShellExtDll(QString dllPath, bool bRegister, bool quiet)
{
	QStringList arguments;
	arguments.append("/s");
	if(!bRegister)
		arguments.append("/u");
	arguments.append(dllPath);
	QString argumentsString;
	for (int i = 0; i < arguments.size(); ++i) {
		if(argumentsString.isEmpty())
			argumentsString+=arguments.at(i);
		else
			if(i == arguments.size())
				argumentsString+=" \""+arguments.at(i)+"\"";
			else
				argumentsString+=' '+arguments.at(i);
	}
	DEBUGCONSOLE(90,"RegisterShellExtDll","start: regsvr32 "+argumentsString);
	//try in Qt, return 5 if need administrator rights
	int result=QProcess::execute("regsvr32",arguments);
	if(result==5 && !quiet)
	{
		DEBUGCONSOLE(90,"RegisterShellExtDll","try it in win32");
		// try with regsvr32, win32 because for admin dialog
		wchar_t arrayArg[65535];
		argumentsString.toWCharArray(arrayArg);
		SHELLEXECUTEINFO sei;
		memset(&sei, 0, sizeof(sei));
		sei.cbSize = sizeof(sei);
		sei.fMask = SEE_MASK_UNICODE;
		sei.lpVerb = TEXT("runas");
		sei.lpFile = TEXT("regsvr32.exe");
		DEBUGCONSOLE(90,"RegisterShellExtDll","arrayArg: "+QString::fromWCharArray(arrayArg));
		sei.lpParameters = arrayArg;
		sei.nShow = SW_SHOW;
		result=!ShellExecuteEx(&sei);
	}
	DEBUGCONSOLE(90,"RegisterShellExtDll","result: "+QString::number(result));
	if(bRegister)
	{
		if(result!=0)
			RegisterShellExtDll(dllPath,false,true);// for be sur that dll is not load in the OS
	}
	else
		HardUnloadDLL(dllPath);
	return (result==0);
}
#endif
