/***************************************************************************
                                     env.h
                              -------------------
 
     Begin        : Tue Dec 18 2007 10:00 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the environement variable and include
 
****************************************************************************/

#ifndef INCLUDE_ENV_H
#define INCLUDE_ENV_H

#include <QString>
#include <QSettings>
#include <QFileInfo>
#ifdef Q_CC_GNU
#include <utime.h>
#endif
#include <time.h>


#include "var.h"
#include "structDef.h"

#ifdef ULTRACOPIER_MODE_WINDOWS
#include <windows.h>
#endif

#if (DEBUG_ULTRACOPIER>0)
	#include <iostream>
	using namespace std;
	#include <QString>
	#if defined (__FILE__) && defined (__LINE__)
	/// \brief Macro for the debug log
	#define DEBUGCONSOLE(a,b,c) debug_console_fonction(a,b,c,__FILE__,__LINE__)
	/// \brief Fonction for send the debug message
	void debug_console_fonction(int number,const QString& fonction,const QString& text,QString file,const int& ligne);
	#else
	/// \brief Macro for the debug log
	#define DEBUGCONSOLE(a,b,c) debug_console_fonction(a,b,c)
	/// \brief Fonction for send the debug message
	void debug_console_fonction(int number,const QString& fonction,const QString& text);
	#endif
#else
	/// \brief Macro for the debug log
	#define DEBUGCONSOLE(a,b,c) /*a,b,c*/
#endif

//action on file exists window
#define FILEEXIST_OVERWRITE			100
#define FILEEXIST_OVERWRITE_ALL			101
#define FILEEXIST_OVERWRITE_IFNOTSAME		102
#define FILEEXIST_OVERWRITE_ALL_IFNOTSAME	103
#define FILEEXIST_OVERWRITE_IFNEWER		104
#define FILEEXIST_OVERWRITE_ALL_IFNEWER		105
#define FILEEXIST_RENAME			110
#define FILEEXIST_RENAME_ALL			111
#define FILEEXIST_SKIP				120
#define FILEEXIST_SKIP_ALL			121
#define FILEEXIST_NOACTION			130
#define FILEEXIST_CANCEL			140

//returned file exist action
#define FILEEXIST_ACTION_OVERWRITE		200
#define FILEEXIST_ACTION_OVERWRITE_IFNOTSAME	201
#define FILEEXIST_ACTION_OVERWRITE_IFNEWER	202
#define FILEEXIST_ACTION_RENAME			210
#define FILEEXIST_ACTION_SKIP			211
#define FILEEXIST_ACTION_CANCEL			220

//action on error window
#define UC_ERROR_RETRY		310
#define UC_ERROR_ENDOFLIST	320
#define UC_ERROR_ENDOFLIST_ALL	321
#define UC_ERROR_SKIP		330
#define UC_ERROR_SKIP_ALL	331
#define UC_ERROR_CANCEL		340

//action returned
#define ERRORACTION_RETRY	411
#define ERRORACTION_ENDOF	412
#define ERRORACTION_SKIP	413
#define ERRORACTION_CLOSE	414

//button activated or not
#define ERROR_DEF_ALL		420
#define ERROR_DEF_NOENDOF	421
#define ERROR_DEF_NOSKIPNOENDOF	422

//choise in the Copy errors
#define COMBO_ERROR_ASK		0
#define COMBO_ERROR_SKIP	1
#define COMBO_ERROR_ATEND	2

//choise in the Copy end
#define COMBO_END_DONTCLOSE	0 //don't close if error are found
#define COMBO_END_NEVERCLOSE	1
#define COMBO_END_ALLWAYSCLOSE	2

//choise in the File collisions
#define COMBO_COLLI_ASK			0
#define COMBO_COLLI_OVERWRITE		1
#define COMBO_COLLI_OVERWRITE_IFNOTSAME	2
#define COMBO_COLLI_OVERWRITE_IFNEWER	3
#define COMBO_COLLI_RENAME		4
#define COMBO_COLLI_SKIP		5

#define COMBO_SORT_NOSORT	0
#define COMBO_SORT_SIZE		1
#define COMBO_SORT_EXT		2

#define COPYMODE_NORMAL		470
#define COPYMODE_OVERWRITE	471
#define COPYMODE_RESUME		472
#define COPYMODE_REMOVEDEST	473

#define FILEEXIST_NO		950
#define FILEEXIST_YES		951
#define FILEEXIST_SAME		952

//choise in free space dialog
#define SPACE_DIAL_FORCE	960
#define SPACE_DIAL_CANCEL	961


//def proto of fonction

/** \brief Return the settings resources
\return the pointer on the QSettings for the settings files
*/
QSettings * getSettingsRes();

/** \brief Return the location of the settings of the application
\return The QString of where is the settings file
*/
QString giveWritablePath(const QString& name="");

/** \brief Give the external name with full path or return the internal name
\return Give the path of where is the resource file (can be internal or external path)
*/
QString giveResourcePath(const QString& url);

/** \brief Return the file in the style if exists else return the internal path in the default style
\return Give the path of where is the resource file of the current theme (can be internal or external path)
*/
QString loadFilePathIntheStyle(const QString& path);

/// \brief Load the style in the setting file
void loadStyle();

/** \brief Load string from setting file
\return The value in QString of the key
*/
QString loadSetting(const QString& group,const QString& key,const QString& defaultValue);


/** \brief Load int from setting file
\return The value in integer of the key
*/
int loadSetting(const QString& group,const QString& key,int defaultValue);

/** \brief Load bool from setting file
\return The value in bollean of the key
*/
bool loadSetting(const QString& group,const QString& key,bool defaultValue);

/** \brief Load a style icon
\return Return a style icon, if not found return the Default style icon
*/
QIcon loadImage(const QString& fileName);

/** \brief Load a style icon as a pixmap
\return Return a style icon as a pixmap, if not found return the Default style icon
*/
QPixmap loadImagePixmap(const QString& fileName);

/** \brief Return if ultracopier catch the copy's system
\return Return true if injected */
bool getSystemCopyCatched();

/** \brief Set the default copier
\param theOrder True if ultracopier should be the default copier
\param quiet If true don't show any dialog
\return Return empty QString if no error append */
QString setSystemCopyCatched(bool theOrder, bool quiet=false);

/** \brief Load new translator
\param lang The lang of load
\return Return true if succes */
bool reloadTheTranslator(const QString& lang="en");

/** \brief Get mount point
\param fileName The full path
\return Return getMountPoint, or empty string if failed */
QString getMountPoint(const QString& fileName);

/** \brief Get on with mount point type is located the file
\param fileName The full path
\return Return getMountPoint, or empty string if failed */
QString getMountType(const QString& fileName);

#ifdef ULTRACOPIER_MODE_WINDOWS
/** \brief Write reg key
\param hKey A handle to an open registry key
\param lpSubKey The name of a subkey that this function opens or creates
\param KeyReg The entry name
\param KeyValue The entry value
\param lenght The lenght
*/
bool newRegQuery(HKEY hKey,LPCTSTR lpSubKey,LPCTSTR KeyReg,const QString& KeyValue);
#endif

/** \brief change file time with system time
\param file File name
\param actime Access time
\param modtime Modification time
\return Return true if succes */
bool changeFileDateTime(QString const& file,time_t actime,time_t modtime);

/** \brief change file time with Qt File Information time
\param file File name on wich the size need be edited
\param file2 Model file time
\return Return true if succes */
bool changeFileDateTime(QString const& file,QString const& file2);

/** \brief Return the free space
\param mountPoint The mount point who check the free space
\return Return the free space on the drive or -1 if failed */
qint64 freeSpaceDrive(const QString& mountPoint);

/** \brief Return the optimal block size
\param mountPoint The mount point to detect the optimal block size
\return Return the optimal block size or -1 if failed */
int optimalBlockSize(const QString& mountPoint);

/// \brief Reset style as default
void resetStyle();

/** \brief Return list of ressource path
\return the list of path of resources */
QStringList getPathOfResource();

/// \brief Reset QIcon cache
void resetQIconCache();

/** \brief Return the starting language
\return The 2 letters code */
QString ReturnStartLang();

/** \brief set if need start when session is open
  \param needBySetup True if need be open with session */
void setOpenWithSession(bool needBySetup);

/** \brief Return if need by open with session
  \return Return if need by open with session */
bool getOpenWithSession();

#endif

#if defined (Q_OS_WIN32) || defined (Q_OS_WINCE)
/** \brief Return the encoded user name
  \return Return the encoded user name open with session */
QString UltracopierWindowsGetUserName();
#endif

QString fromPercentEncodingLocal(QString text);

void initTheTranslations();

QList<translatorLang> getTheTranslations();

translatorLang getTheTranslation(QString lang);

bool theTranslationExists(QString lang);

