##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

# include (ugenecl.pri)

include( ../ugene_globals.pri )
UGENE_RELATIVE_DESTDIR = ''

QT += xml network script
TEMPLATE = app
CONFIG +=qt dll thread debug_and_release console
DEFINES+= QT_DLL QT_FATAL_ASSERT
INCLUDEPATH += src _tmp ../core/src ../core/_tmp

LIBS += -L../_release -lcore

!debug_and_release|build_pass {

    CONFIG(debug, debug|release) {
        TARGET = ugenecld
        DEFINES+=_DEBUG
        DESTDIR=../_debug
        MOC_DIR=_tmp/moc/debug
        OBJECTS_DIR=_tmp/obj/debug
        LIBS -= -L../_release -lcore
        LIBS += -L../_debug -lcored
    }

    CONFIG(release, debug|release) {
        TARGET = ugenecl
        DESTDIR=../_release
        DEFINES+=NDEBUG
        MOC_DIR=_tmp/moc/release
        OBJECTS_DIR=_tmp/obj/release   
    }

}

UI_DIR=_tmp/ui
RCC_DIR=_tmp/rcc

win32 {
    LIBS += -luser32     # to import CharToOemA with nmake build

    QMAKE_CXXFLAGS_WARN_ON = -W3
    QMAKE_CFLAGS_WARN_ON = -W3
    RC_FILE = ugenecl.rc
}

macx {
    RC_FILE = images/ugenecl_mac.icns
}



unix {
    target.path = $$UGENE_INSTALL_DIR/$$UGENE_RELATIVE_DESTDIR
    INSTALLS += target
}
