/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _NEIGHBORJOINTESTS_H
#define _NEIGHBORJOINTESTS_H
#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GObject.h>
#include <phyltree/PhyTreeGeneratorTask.h>

#include <QtXml/QDomElement>
#include <QFileInfo>
#include <QList>

namespace GB2{

class PhyTreeObject;
class MAlignmentObject;

class GTest_NeighborJoin : public GTest {
	Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_NeighborJoin, "test-neighbor-join");

    void prepare();
    Task::ReportResult report();
    void cleanup();

private:    
    QString inputDocCtxName;
    QString resultCtxName;
    Document* maDoc;
    Document* treeDoc;
    PhyTreeGeneratorTask* task;
    MAlignmentObject* input;
    PhyTreeObject* treeObjFromDoc;
};


class  PhylipPluginTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};

}

#endif