/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "PhylipPlugin.h"

#include <core_api/AppContext.h>
#include <core_api/Task.h>
#include <core_api/Log.h>
#include <gobjects/MAlignmentObject.h>
#include <gobjects/GObjectTypes.h>

#include <util_algorithm/GAutoDeleteList.h>
#include <util_gui/GUIUtils.h>
#include <util_gui/DialogUtils.h>

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTest.h>
#include <test_framework/GTestFrameworkComponents.h>
#include <test_framework/xmltest/DocumentModelTests.h>

#include <QtGui/QDialog>
#include <QtGui/QFileDialog>

#include "PhylipPluginTests.h"
#include "NeighborJoinAdapter.h"
#include <phyltree/PhyTreeGeneratorRegistry.h>

#define ULOG_CAT_PHYLIP "Plugin: NEIGHBOR JOIN"

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
	PhylipPlugin * plug = new PhylipPlugin();
	return plug;
}

//LogCategory log(ULOG_CAT_MUSCLE);
const QString PhylipPlugin::PHYLIP_NEIGHBOUR_JOIN("Phylip Neighbor Join");

PhylipPlugin::PhylipPlugin() 
: Plugin(tr("Phylip plugin"), tr("PHYLIP(the PHYLogeny Inference Package) is a package of programs \
                                 for inferring phylogenies (evolutionary trees).\nOriginal version\
                                 at:http://evolution.genetics.washington.edu/phylip.html"))
{

    PhyTreeGeneratorRegistry* registry = AppContext::getPhyTreeGeneratorRegistry();
    registry->registerPhyTreeGenerator(new NeighborJoinAdapter(), PHYLIP_NEIGHBOUR_JOIN);

    GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);

    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = PhylipPluginTests::createTestFactories();

    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        Q_UNUSED(res);
        assert(res);
    }
}

PhylipPlugin::~PhylipPlugin() {
    //nothing to do
}


}//namespace
