/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <datatype/PhyTree.h>

#ifndef _GB2_NEIGHBORJOIN_ADAPTER_H_
#define _GB2_NEIGHBORJOIN_ADAPTER_H_

#include <QtCore/QObject>
#include <core_api/SubstMatrixRegistry.h>
#include <phyltree/PhyTreeGenerator.h>
#include <phyltree/CreatePhyTreeSettings.h>

namespace GB2 { 

	class MAlignment;
	class TaskStateInfo;

	class NeighborJoinAdapter : public PhyTreeGenerator {
	public:
        PhyTree calculatePhyTree(const MAlignment& ma, const CreatePhyTreeSettings& s, TaskStateInfo& ti);
        virtual void setupCreatePhyTreeUI(CreatePhyTreeDialogController* c, const MAlignment& ma);
    private:
        static QMutex runLock;
	};

}//namespace

#endif