/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_UHMMER3_PLUGIN_H_
#define _GB2_UHMMER3_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/AppContext.h>
#include <gobjects/DNASequenceObject.h>
#include <core_api/ObjectViewModel.h>

#include <search/uHMM3SearchLocalTask.h>

namespace GB2 {

class UHMM3MSAEditorContext;
class UHMM3ADVContext;

class UHMM3Plugin : public Plugin {
    Q_OBJECT
public:
    UHMM3Plugin();
    ~UHMM3Plugin();
    
private:
    DNASequenceObject * getDnaSequenceObject() const;
    
private slots:
    void sl_buildProfile();
    void sl_searchHMMSignals();
    void sl_phmmerSearch();

private:
    UHMM3SearchLocalTaskFactory searchLocalTaskFactory;
    UHMM3MSAEditorContext *     msaEditorCtx;
    UHMM3ADVContext *           advCtx;
    
}; // uHMM3Plugin

class UHMM3MSAEditorContext : public GObjectViewWindowContext {
    Q_OBJECT
public:
    UHMM3MSAEditorContext( QObject * p );
    
protected slots:
    void sl_build();
    
protected:
    virtual void initViewContext( GObjectView * view );
    virtual void buildMenu( GObjectView * v, QMenu * m );
    
}; // UHMM3MSAEditorContext

class UHMM3ADVContext : public GObjectViewWindowContext {
    Q_OBJECT
public:
    UHMM3ADVContext( QObject * p );
    
protected slots:
    void sl_search();
    
private:
    QWidget * getParentWidget( QObject * sender );
    DNASequenceObject * getSequenceInFocus( QObject * sender );
    
protected:
    virtual void initViewContext( GObjectView * view );
    
}; // UHMM3ADVContext

} // GB2

#endif // _GB2_UHMMER3_PLUGIN_H_
