/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_UHMM3_SEARCH_LOCAL_TASK_H_
#define _GB2_UHMM3_SEARCH_LOCAL_TASK_H_

#include <util_tasks/LoadDocumentTask.h>

#include <distributed_computing/LocalTask.h>
#include <distributed_computing/RemoteMachine.h>
#include <distributed_computing/RemoteTask.h>
#include "uHMM3SearchTask.h"

namespace GB2 {

class UHMM3SearchLocalTaskSettings : public LocalTaskSettings {
private:
    static const int SERIALIZED_HMM_LIST_SZ = 22;
    static const int SERIALIZED_LOCAL_TASK_SETTINGS_LIST_SZ = 3;
    static const int SERIALIZED_HMM_SEARCH_SETTINGS_LIST_SZ = 18;
    
public:
    UHMM3SearchLocalTaskSettings( const UHMM3SearchTaskSettings & settings, P7_HMM * hmm, const DNASequence & sequence );
    UHMM3SearchLocalTaskSettings();
    virtual ~UHMM3SearchLocalTaskSettings();
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );
    
    UHMM3SearchTaskSettings getSearchTaskSettings() const;
    P7_HMM * getHMM() const;
    DNASequence getDNASequence() const;
    
private:
    QVariant serializeSettings() const;
    bool deserializeSettings( const QVariant & data );
    
    QVariant serializeHMM()const;
    bool deserializeHMM( const QVariant & data );
    
private:
    UHMM3SearchTaskSettings settings;
    P7_HMM *                hmm;
    DNASequence             sequence;
    
}; // UHMM3SearchLocalTaskSettings

class UHMM3SearchLocalTaskResult : public LocalTaskResult {
public:
    UHMM3SearchLocalTaskResult( const UHMM3SWSearchTaskResult & result );
    UHMM3SearchLocalTaskResult();
    virtual ~UHMM3SearchLocalTaskResult();
    
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );
    
    void setResult( const UHMM3SWSearchTaskResult & );
    UHMM3SWSearchTaskResult getResult() const;
    
private:
    QVariant serializeHMM3SearchSeqDomainResult( const UHMM3SearchSeqDomainResult & ) const;
    bool deserializeHMM3SearchSeqDomainResult( const QVariant & data, UHMM3SearchSeqDomainResult * domainRes );
    
private:
    UHMM3SWSearchTaskResult result;
    
}; // UHMM3SearchLocalTaskResult

class UHMM3SearchLocalTask : public LocalTask {
    Q_OBJECT
public:
    /* argument - newly allocated settings. UHMM3SearchLocalTask takes responsibility for it */
    UHMM3SearchLocalTask( UHMM3SearchLocalTaskSettings * settings );
    virtual ~UHMM3SearchLocalTask();
    
    virtual void prepare();
    virtual ReportResult report();
    
    virtual const LocalTaskResult * getResult() const;
    
    QString generateReport() const;
    
private:
    UHMM3SearchLocalTaskResult      result;
    UHMM3SearchLocalTaskSettings *  settings;
    UHMM3SWSearchTask *             searchTask;
    
}; // UHMM3SearchLocalTask

class UHMM3RemoteSearchToAnnotationsTask : public Task {
    Q_OBJECT
public:
    UHMM3RemoteSearchToAnnotationsTask( const QString & hmmfile, const DNASequence & sequence, 
        const UHMM3SearchTaskSettings & settings, RemoteMachineSettings * m, AnnotationTableObject * ato, 
        const QString & group, const QString & aname );
    
    ~UHMM3RemoteSearchToAnnotationsTask();
    
    virtual QString generateReport() const;
    virtual QList< Task* > onSubTaskFinished( Task * subTask );
    
private:
    void checkArgs();
    
private:
    QString                             hmmfile;
    DNASequence                         sequence;
    QString                             agroup;
    QString                             aname;
    UHMM3SearchTaskSettings             searchSettings;
    QPointer< AnnotationTableObject >   annotationObj;
    LoadDocumentTask *                  loadHmmTask;
    RemoteTask *                        searchTask;
    RemoteMachine *                     machine;
    RemoteMachineSettings *             machineSettings;
    CreateAnnotationsTask *             createAnnotationsTask;
    P7_HMM *                            hmm;
    
}; // UHMM3RemoteSearchToAnnotationsTask

typedef SimpleLocalTaskFactoryImpl< UHMM3SearchLocalTaskSettings, UHMM3SearchLocalTask, UHMM3SearchLocalTaskResult > 
    UHMM3SearchLocalTaskFactory;

} // GB2

#endif // _GB2_UHMM3_SEARCH_LOCAL_TASK_H_
