/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <QtGui/QMenu>
#include <QtGui/QAction>
#include <QtGui/QMessageBox>
#include <QtCore/QMap>
#include <QtCore/QFile>

#include <util_algorithm/GAutoDeleteList.h>
#include <util_gui/GUIUtils.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/ADVUtils.h>
#include <core_api/AppContext.h>
#include <core_api/Log.h>
#include <core_api/SecStructPredictAlgRegistry.h>
#include <datatype/BioStruct3D.h>
#include <gobjects/AnnotationSettings.h>
#include <util_sec_struct_predict/SecStructPredictTask.h>

#include "GorIVPlugin.h"
#include "GorIVAlgTask.h"
#include "gor.h"

namespace GB2 {

static LogCategory log(ULOG_CAT_PLUGIN_SEC_STRUCT_PREDICT);

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    SecStructPredictPlugin* plug = new SecStructPredictPlugin();
    return plug;
}

SecStructPredictPlugin::SecStructPredictPlugin() : Plugin(tr("GORIV"), tr("GORIV protein secondary structure prediction")) {
    // Register GORIV algorithm
    SecStructPredictAlgRegistry* registry = AppContext::getSecStructPredictAlgRegistry();
    SecStructPredictTaskFactory* taskFactory = new GorIVAlgTask::Factory;
    registry->registerAlgorithm(taskFactory, GorIVAlgTask::taskName);

    //Register GORIV annotation settings
    AnnotationSettingsRegistry* asr =AppContext::getAnnotationsSettingsRegistry();
    AnnotationSettings* as = new AnnotationSettings(GORIV_ANNOTATION_NAME, true, QColor(102,255, 0), true);
    as->nameQuals.append(BioStruct3D::SecStructTypeQualifierName);
    asr->changeSettings(QList<AnnotationSettings*>() << as, false);
}

SecStructPredictPlugin::~SecStructPredictPlugin() {
}


}//namespace

