/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BOWTIE_WORKER_H_
#define _GB2_BOWTIE_WORKER_H_

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>
#include "BowtieTask.h"

namespace GB2 {

	namespace LocalWorkflow {

		class BowtiePrompter : public PrompterBase<BowtiePrompter> {
			Q_OBJECT
		public:
			BowtiePrompter(Actor* p = 0) : PrompterBase<BowtiePrompter>(p) {}
		protected:
			QString composeRichDoc();
		};

		class BowtieWorker : public BaseWorker {
			Q_OBJECT
		public:
			BowtieWorker(Actor* a) : BaseWorker(a, false), reads(NULL), ebwt(NULL), output(NULL) {}
			virtual void init() ;
			virtual bool isReady();
			virtual Task* tick() ;
			virtual bool isDone() ;
			virtual void cleanup() {}
			private slots:
				void sl_taskFinished();

		protected:
			CommunicationChannel *reads, *ebwt, *output;
			QString resultName,transId;
			DnaAssemblyToRefTaskSettings settings;
		}; 

		class BowtieWorkerFactory : public DomainFactory {
		public:
			static const QString ACTOR_ID;
			static void init();
			BowtieWorkerFactory() : DomainFactory(ACTOR_ID) {}
			virtual Worker* createWorker(Actor* a) {return new BowtieWorker(a);}
		};

		/************************************************************************/
		/* Bowtie build                                                         */
		/************************************************************************/

		class BowtieBuildPrompter : public PrompterBase<BowtieBuildPrompter> {
			Q_OBJECT
		public:
			BowtieBuildPrompter(Actor* p = 0) : PrompterBase<BowtieBuildPrompter>(p) {}
		protected:
			QString composeRichDoc();
		};

		class BowtieBuildWorker : public BaseWorker {
			Q_OBJECT
		public:
			BowtieBuildWorker(Actor* a) : BaseWorker(a), output(NULL), done(false) {}
			virtual void init() ;
			virtual bool isReady();
			virtual Task* tick() ;
			virtual bool isDone() ;
			virtual void cleanup() {}
			private slots:
				void sl_taskFinished();

		protected:
			CommunicationChannel *output;
			QString resultName,transId;
			GUrl refSeqUrl;
			GUrl ebwtUrl;
			bool done;
		}; 

		class BowtieBuildWorkerFactory : public DomainFactory {
		public:
			static const QString ACTOR_ID;
			static void init();
			BowtieBuildWorkerFactory() : DomainFactory(ACTOR_ID) {}
			virtual Worker* createWorker(Actor* a) {return new BowtieBuildWorker(a);}
		};

		/************************************************************************/
		/* Bowtie index reader                                                  */
		/************************************************************************/

		class BowtieIndexReaderPrompter : public PrompterBase<BowtieIndexReaderPrompter> {
			Q_OBJECT
		public:
			BowtieIndexReaderPrompter(Actor* p = 0) : PrompterBase<BowtieIndexReaderPrompter>(p) {}
		protected:
			QString composeRichDoc();
		};

		class BowtieIndexReaderWorker : public BaseWorker {
			Q_OBJECT
		public:
			BowtieIndexReaderWorker(Actor* a) : BaseWorker(a), output(NULL), done(false) {}
			virtual void init() ;
			virtual bool isReady();
			virtual Task* tick() ;
			virtual bool isDone() ;
			virtual void cleanup() {}
			private slots:
				void sl_taskFinished();

		protected:
			CommunicationChannel *output;
			QString resultName,transId;
			GUrl ebwtUrl;
			bool done;
		}; 

		class BowtieIndexReaderWorkerFactory : public DomainFactory {
		public:
			static const QString ACTOR_ID;
			static void init();
			BowtieIndexReaderWorkerFactory() : DomainFactory(ACTOR_ID) {}
			virtual Worker* createWorker(Actor* a) {return new BowtieIndexReaderWorker(a);}
		};

	}//Workflow namespace
}//GB2 namespace

#endif // BOWTIE_WORKER
