##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

# include (bowtie.pri)
include( ../../ugene_globals.pri )
UGENE_RELATIVE_DESTDIR = 'plugins'

TEMPLATE = lib
CONFIG +=qt dll thread debug_and_release
QT += network xml script
DEFINES+= QT_DLL "BOWTIE_VERSION=\"\"0.12.5\"\"
INCLUDEPATH += src _tmp ../../core/src  ../../core/_tmp
LIBS += -L../../_release -lcore

!debug_and_release|build_pass {

    CONFIG(debug, debug|release) {
        TARGET = bowtied
        DEFINES+=_DEBUG
        CONFIG +=console
        DESTDIR=../../_debug/plugins
        MOC_DIR=_tmp/moc/debug
        OBJECTS_DIR=_tmp/obj/debug
        LIBS -= -L../../_release -lcore
        LIBS += -L../../_debug -lcored
    }

    CONFIG(release, debug|release) {
        TARGET = bowtie
        DEFINES+=NDEBUG
        DESTDIR=../../_release/plugins
        MOC_DIR=_tmp/moc/release
        OBJECTS_DIR=_tmp/obj/release
    }
}


UI_DIR=_tmp/ui
RCC_DIR=_tmp/rcc

win32 {
    QMAKE_CXXFLAGS_WARN_ON = -W3
    QMAKE_CFLAGS_WARN_ON = -W3

    QMAKE_MSVC_PROJECT_NAME=plugin_3rd_bowtie
}


unix {
    target.path = $$UGENE_INSTALL_DIR/$$UGENE_RELATIVE_DESTDIR
    INSTALLS += target
}
