/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_FORMAT_H_
#define _GB2_WORKFLOW_FORMAT_H_

#include "WorkflowDesignerPlugin.h"
#include <core_api/DocumentModel.h>
#include <core_api/GObject.h>
#include <core_api/ObjectViewModel.h>
#include <util_tasks/ObjectViewTasks.h>

#include <QtCore/QStringList>

#include <QtXml/qdom.h>
class QDomDocument;

namespace GB2 {

class WorkflowView;

class WorkflowDocFormat : public DocumentFormat {
    Q_OBJECT
public:
    WorkflowDocFormat(QObject* p);

	virtual DocumentFormatId getFormatId() const {return "WorkflowDocFormat";}

	virtual const QString& getFormatName() const {return formatName;}

	virtual Document* createNewDocument(IOAdapterFactory* io, const QString& url, const QVariantMap& fs = QVariantMap());
	
	virtual Document* loadDocument(IOAdapter* io, TaskStateInfo& ti, const QVariantMap& fs, DocumentLoadMode mode = DocumentLoadMode_Whole);

    virtual void storeDocument( Document* d, TaskStateInfo& ts, IOAdapter* io);

	virtual bool checkRawData(const QByteArray& rawData) const;

private:
	QString formatName;
};

class WorkflowGObject : public GObject {
    Q_OBJECT
public:
    static const GObjectType TYPE;
    WorkflowGObject(const QString& objectName, const QDomDocument& d, const QVariantMap& map = QVariantMap()) 
        : GObject(TYPE, objectName), xml(d), view(NULL) { Q_UNUSED(map); }

    QDomDocument getXML() const {return xml;}
    void setXML(QDomDocument);
    virtual GObject* clone() const;
    virtual bool isTreeItemModified () const;
    void setView(WorkflowView* view);
    WorkflowView* getView() const {return view;}

protected:
    QDomDocument xml;
    WorkflowView* view;
};

class WorkflowViewFactory : public GObjectViewFactory {
    Q_OBJECT
public:
    static const GObjectViewFactoryId ID;
    WorkflowViewFactory(QObject* p = NULL) : GObjectViewFactory(ID, GB2::WorkflowDesignerPlugin::tr("Workflow Designer"), p) {}    

    virtual bool canCreateView(const MultiGSelection& multiSelection);
    virtual Task* createViewTask(const MultiGSelection& multiSelection, bool single = false);
};

class OpenWorkflowViewTask : public ObjectViewTask {
    Q_OBJECT
public:
    OpenWorkflowViewTask(Document* doc);
    virtual void open();
};

}//namespace

#endif
