/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_RF_BASE_ALG_H_
#define _GB2_RF_BASE_ALG_H_

#include <core_api/DNAAlphabet.h>
#include <core_api/Task.h>
#include <util_repeat_finder/RepeatFinderSettings.h>

#include <QtCore/QVector>

namespace GB2 {

#define PCHAR_MATCHES(x, y) (*(x) == *(y) && *(x) != unknownChar)
#define CHAR_MATCHES(x, y)  ((x) == (y) && (x) != unknownChar)


class Tandem{
public:
    Tandem(quint32 _offset, quint32 _repeatLen, quint32 _size):
        offset(_offset),repeatLen(_repeatLen),size(_size),rightSide(_offset+_size-_repeatLen)
    {
    }
    Tandem(const Tandem& t):
        offset(t.offset),repeatLen(t.repeatLen),size(t.size),rightSide(t.rightSide)
    {
    }
    Tandem& operator =(const Tandem& t){
        offset=t.offset;
        repeatLen=t.repeatLen;
        size=t.size;
        rightSide=t.rightSide;
        return *this;
    }
    bool operator < (const Tandem& t) const;
    bool extend (const Tandem& t);

    // offset of tandem from beginning of the sequence
    quint64 offset;
    // repeat len
    int repeatLen;
    //size of tandem in nucleotides
    int size;
    quint64 rightSide;
};

class RFAlgorithmBase : public Task {
    Q_OBJECT
public:
    RFAlgorithmBase(RFResultsListener* l, 
                    const char* seqX, int sizeX,
                    const char* seqY, int sizeY, DNAAlphabetType seqType, 
                    int w, int k, TaskFlags flags = TaskFlags_NR_FOSCOE);

    void setReportReflected(bool v) {reportReflected = v;}
    
    void setRFResultsListener(RFResultsListener*);
    
    void prepare();
    
    static RFAlgorithmBase* createTask(RFResultsListener* l,
                                        const char *seqx, int sizeX,
                                        const char *seqY, int sizeY,
                                        DNAAlphabet *al, int w,
                                        int mismatches = 0, RFAlgorithm alg = RFAlgorithm_Auto,
                                        int nThreads = MAX_PARALLEL_SUBTASKS_AUTO);

protected:
    // adds single result to global results 
    void addToResults(const RFResult& r);

    // adds multiple results to global results 
    void addToResults(const QVector<RFResult>& newResults);

    //always return true. bool -> to use in assertions
    bool checkResults(const QVector<RFResult>& v);
    bool checkResult(const RFResult& v);

    const char*             seqX;
    const char*             seqY;
    const int               SIZE_X;
    const int               SIZE_Y;
    const DNAAlphabetType   SEQ_TYPE;
    const int               WINDOW_SIZE;
    const int               K;
    const int               C;

    bool                    reflective;
    char                    unknownChar;

    RFResultsListener*      resultsListener;
    bool                    reportReflected;
};

} //namespace

#endif
