/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "GenomeAlignerPlugin.h"
#include "GenomeAlignerTask.h"
#include "GenomeAlignerSettingsWidget.h"

#include <core_api/AppContext.h>
#include <core_api/MainWindow.h>
#include <core_api/DnaAssemblyAlgRegistry.h>

#include "GenomeAlignerTask.h"
#include "GenomeAlignerWorker.h"

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin * GB2_PLUGIN_INIT_FUNC() {
    GenomeAlignerPlugin * plug = new GenomeAlignerPlugin();
    return plug;
}

GenomeAlignerPlugin::GenomeAlignerPlugin() : Plugin( tr("UGENE genome aligner"), tr("Assembly DNA to reference sequence") ) {
    // Register GenomeAligner algorithm
    DnaAssemblyAlgRegistry* registry = AppContext::getDnaAssemblyAlgRegistry();
    DnaAssemblyToRefTaskFactory* taskFactory = new GenomeAlignerTask::Factory;
    registry->registerTask(GenomeAlignerTask::taskName, taskFactory);
    
    if (AppContext::getMainWindow()) {
        DnaAssemblyGUIExtensionFactory* guiFactory = new GenomeAlignerSettingsWidget::Factory;
        registry->registerGUIExtension(GenomeAlignerTask::taskName, guiFactory);
    }

    LocalWorkflow::GenomeAlignerWorkerFactory::init();

}




} //namespace
