/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ENZYMES_TESTS_H_
#define _GB2_ENZYMES_TESTS_H_

#include <core_api/GObject.h>
#include <core_api/LRegion.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <test_framework/xmltest/DocumentModelTests.h>

#include <QtCore/QMultiMap>
#include <QtXml/QDomElement>

namespace GB2 {

class LoadEnzymeFileTask;
class AnnotationTableObject;
class DNASequenceObject;

//cppcheck-suppress noConstructor
class GTest_FindEnzymes : public GTest {
    Q_OBJECT
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_FindEnzymes, "find-enzymes");

    void prepare();
    QList<Task*> onSubTaskFinished(Task* subTask);
    ReportResult report();
    void cleanup();
    
private:
    int minHits;
    int maxHits;
    QString                 enzymesUrl;
    QString                 seqObjCtx;
    DNASequenceObject*      seqObj;
    LRegion                 region;
    QStringList             enzymeNames;
    AnnotationTableObject*  aObj;
    LoadEnzymeFileTask*     loadTask;
    QMultiMap<QString, LRegion> resultsPerEnzyme;
};

class EnzymeTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};

} //namespace

#endif
