/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DotPlotSplitter.h"
#include "DotPlotWidget.h"

#include <QtGui/QVBoxLayout>

namespace GB2 {

DotPlotSplitter::DotPlotSplitter(AnnotatedDNAView* a)
: ADVSplitWidget(a)
{
	QVBoxLayout *layout = new QVBoxLayout;
	splitter = new QSplitter(Qt::Horizontal);

	Q_ASSERT(layout);
	layout->setSpacing(0);
	layout->setContentsMargins(0,0,3,0);
	layout->addWidget(splitter);
	setAcceptDrops(false);

	setLayout(layout);
}

// add DotPlotWidget to this splitter
void DotPlotSplitter::addView(DotPlotWidget* view) {

	dotPlotList.append(view);
	Q_ASSERT(splitter);
	splitter->insertWidget(0, view);
}

// remove DotPlotWidget from this splitter
void DotPlotSplitter::removeView(DotPlotWidget* view) {

	dotPlotList.removeAll(view);
}

bool DotPlotSplitter::isEmpty() const{

	return dotPlotList.isEmpty();
}

// build popup menu for all DotPlotWidgets
// each DotPlotWidget defines if it should add menu
void DotPlotSplitter::buildPopupMenu(QMenu *m) {

	foreach (DotPlotWidget *w, dotPlotList) {
		Q_ASSERT(w);
		w->buildPopupMenu(m);
	}
}

} // namespace
