/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DOT_PLOT_DIALOG_H_
#define _GB2_DOT_PLOT_DIALOG_H_

#include <ui/ui_DotPlotDialog.h>

#include <util_repeat_finder/RepeatFinderSettings.h>
#include <QtGui/QDialog>

namespace GB2 {
class ADVSequenceObjectContext;

class DotPlotDialog : public QDialog, public Ui_DotPlotDialog{
	Q_OBJECT
public:
    DotPlotDialog(QWidget *parent, const QList<ADVSequenceObjectContext *>& sequences, int minLen, int identity, ADVSequenceObjectContext *seqX, ADVSequenceObjectContext *seqY);

    virtual void accept();

	ADVSequenceObjectContext	*getXSeq() const {return xSeq;}
	ADVSequenceObjectContext	*getYSeq() const {return ySeq;}

	int getMinLen() const;
	int getMismatches() const;
	RFAlgorithm getAlgo() const;

protected slots:
    void sl_minLenHeuristics();
	void sl_hundredPercent();

private:
	QList<ADVSequenceObjectContext *> sequences;
	ADVSequenceObjectContext *xSeq, *ySeq;
};

} //namespace

#endif
