/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <core_api/AppContext.h>

#include "DirectSocketRemoteMachine.h"
#include "DirectSocketRemoteTaskServer.h"
#include "DirectSocketProtocolUI.h"

static const int DIRECT_SOCKET_PORT_MAX = 0x7fff;

namespace GB2 {

DirectSocketProtocolUI::DirectSocketProtocolUI()
{
    setupUi(this);
}

DirectSocketProtocolUI::~DirectSocketProtocolUI()
{
}

RemoteMachineSettings * DirectSocketProtocolUI::createMachine() const
{
    if( !validatePort() || !validateHost() )
    {
        return NULL;
    }
    return new DirectSocketRemoteMachineSettings(hostLineEdit->text(), portSpinBox->value());
}

void DirectSocketProtocolUI::initializeWidget(const RemoteMachineSettings *settings)
{
    const DirectSocketRemoteMachineSettings *castedSettings =
            dynamic_cast<const DirectSocketRemoteMachineSettings *>(settings);
    if(NULL != castedSettings)
    {
        hostLineEdit->setText(castedSettings->getHost());
        portSpinBox->setValue(castedSettings->getPort());
    }
}

QString DirectSocketProtocolUI::validate() const {
    if( !validateHost() ) {
        return tr( "Host name is not valid!" );
    }
    if( !validatePort() ) {
        return tr( "Port is not valid" );
    }
    return QString();
}

bool DirectSocketProtocolUI::validateHost() const {
    return !hostLineEdit->text().isEmpty();
}

bool DirectSocketProtocolUI::validatePort() const {
    return !( portSpinBox->value() < 0 || portSpinBox->value() > DIRECT_SOCKET_PORT_MAX );
}

void DirectSocketProtocolUI::clearWidget() {
    hostLineEdit->setText( "" );
    portSpinBox->setValue( DirectSocketRemoteTaskServer::DIRECT_SOCKET_TCP_SERVER_DEFAULT_PORT );
}

} // namespace GB2
