/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef DIRECTSOCKETPROTOCOL_H
#define DIRECTSOCKETPROTOCOL_H

#include <QtNetwork/QTcpServer>
#include <distributed_computing/Protocol.h>

namespace GB2 {

class DirectSocketProtocol : public QObject, public Protocol
{
    Q_OBJECT
public:
    DirectSocketProtocol();
    virtual ~DirectSocketProtocol();

    virtual QString getId() const;

    virtual void setEnabled( bool enable );
    virtual bool isEnabled() const;

    virtual RemoteMachineScanner * getScanner() const;
public slots:
    void sl_newConnection();
public:
    static const QString id;
private:
    QTcpServer server;
};

} // namespace GB2

#endif // DIRECTSOCKETPROTOCOL_H
