/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <core_api/AppContext.h>
#include "DirectSocketPlugin.h"

namespace GB2 {

extern "C" Q_DECL_EXPORT GB2::Plugin* GB2_PLUGIN_INIT_FUNC()
{
    DirectSocketPlugin* plug = new DirectSocketPlugin();
    return plug;
}

const QString DirectSocketPlugin::DIRECT_SOCKET_PROTOCOL_ID = "Direct socket protocol";

DirectSocketPlugin::DirectSocketPlugin():
    Plugin(tr("Direct Socket Transport"),
           tr("An implementation of remote task transport using direct network connection")),
    protocolUI((NULL == AppContext::getMainWindow())? NULL:(new DirectSocketProtocolUI())),
    protocolInfo( DIRECT_SOCKET_PROTOCOL_ID , &remoteTaskServer, protocolUI.get(),
                 &remoteMachineFactory, &remoteMachineScanner )
{
    AppContext::getProtocolInfoRegistry()->registerProtocolInfo(&protocolInfo);
}

DirectSocketPlugin::~DirectSocketPlugin()
{
}

} // namespace GB2
