/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CIRCULAR_VIEW_SPLITTER_H_
#define _GB2_CIRCULAR_VIEW_SPLITTER_H_

#include "CircularView.h"
#include "CircularItems.h"

#include <util_ov_annotated_dna/ADVSplitWidget.h>

#include <QToolBar>
#include <QToolButton>
#include <QAction>
#include <QGraphicsScene>

namespace GB2 {

class CircularViewHeaderWidget;

class CircularViewSplitter : public ADVSplitWidget{
	Q_OBJECT
public:
	CircularViewSplitter( AnnotatedDNAView* view);
	// there are no special object handling with this view
	// it only shows existing AO only
	virtual bool acceptsGObject(GObject* objects) {Q_UNUSED(objects);return false;} 
	virtual void updateState(const QVariantMap& m);
	virtual void saveState(QVariantMap& m);
	void addView(CircularView* view);
	void adaptSize();
	void removeView(CircularView* view);
	bool isEmpty();
    const QList<CircularView*>& getViewList() const { return circularViewList; }
public slots:
    void sl_save2file();
private:
	QSplitter* splitter;
    CircularViewHeaderWidget* header;
	QList<CircularView*> circularViewList;
};

class CircularViewHeaderWidget : public QWidget {
    Q_OBJECT
public:
    CircularViewHeaderWidget(CircularViewSplitter* p);

public slots:
    void sl_save2file();
private:
    void scene2file();

    CircularViewSplitter*   ctx;

    QToolBar*               toolBar;
    QToolButton*            saveButton;
    QGraphicsScene          scene;
};

} //namespace GB2

#endif //_GB2_CIRCULAR_VIEW_SPLITTER_H_