/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include "CoreLibConstants.h"

namespace GB2 {

namespace Workflow {

const QString CoreLibConstants::READ_TEXT_ACTOR("read.text");
const QString CoreLibConstants::WRITE_TEXT_ACTOR("write.text");

const QString CoreLibConstants::WRITE_FASTA_ACTOR("write.fasta");
const QString CoreLibConstants::WRITE_GENBANK_ACTOR("write.gbk");
const QString CoreLibConstants::WRITE_CLUSTAL_ACTOR("write.clustalw");
const QString CoreLibConstants::WRITE_STOCKHOLM_ACTOR("write.stockholm");
const QString CoreLibConstants::WRITE_MSA_ACTOR("write.malignment");
const QString CoreLibConstants::WRITE_SEQ_ACTOR("write.sequence");
const QString CoreLibConstants::WRITE_FASTQ_ACTOR("write.fastq");

const QString CoreLibConstants::GENERIC_READ_MA_ACTOR("read.malignment");
const QString CoreLibConstants::GENERIC_READ_SEQ_ACTOR("read.sequence");

const QString CoreLibConstants::URL_IN_ATTR_ID("URL_IN");
const QString CoreLibConstants::URL_OUT_ATTR_ID("URL_OUT");
const QString CoreLibConstants::URL_LOCATION_ATTR_ID("URL_LOCATION");
const QString CoreLibConstants::APPEND_ATTR_ID("append");
const QString CoreLibConstants::DOCUMENT_FORMAT_ATTR_ID("DOCUMENT_FORMAT");
const QString CoreLibConstants::URL_SLOT_ID("URL");

const QString CoreLibConstants::DATA_PORT_ID("data");
const QString CoreLibConstants::IN_PORT_ID("in");
const QString CoreLibConstants::OUT_PORT_ID("out");

const QString CoreLibConstants::FASTA_HEADER_SLOT_ID("fasta.header");
const QString CoreLibConstants::GENBANK_ACN_SLOT_ID("genbank.ACN");

const Descriptor CoreLibConstants::URL_IN_ATTR() {return Descriptor(URL_IN_ATTR_ID, tr("Input file"), tr("Location of input data file(s)"));}
const Descriptor CoreLibConstants::URL_OUT_ATTR() {return Descriptor(URL_OUT_ATTR_ID, tr("Output file"), tr("Location of output data file"));}
const Descriptor CoreLibConstants::READ_URL_SLOT() {return Descriptor(URL_SLOT_ID, tr("Source URL"), tr("Location of a corresponding input file."));}
const Descriptor CoreLibConstants::URL_LOCATION_ATTR() {return Descriptor(URL_LOCATION_ATTR_ID, tr("Located on"), tr("Machine file(s) are located on")); }

const QString CoreLibConstants::GENBANK_TYPESET_ID("genbank.content");
const QString CoreLibConstants::FASTA_TYPESET_ID("fasta.content");
const QString CoreLibConstants::FASTQ_TYPESET_ID("fastq.content");
const QString CoreLibConstants::SEQ_TYPESET_ID("seq.content");
const QString CoreLibConstants::TEXT_TYPESET_ID("text.content");
const QString CoreLibConstants::MA_TYPESET_ID("ma.content");

} // Workflow

} // GB2
