/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DESC_H_
#define _GB2_DESC_H_

#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QMetaType>

#ifdef _GB2_CORE_BUILD_DLL_
#define WCOREAPI_EXPORT Q_DECL_EXPORT
#else
#define WCOREAPI_EXPORT Q_DECL_IMPORT
#endif


namespace GB2 {

/**
 * Class Descriptor represents an uniquely identifiable entity, 
 * which can be exposed to user in some way. So it also has a name and a description.
 */
class WCOREAPI_EXPORT Descriptor {
public:
    Descriptor(const QString& id, const QString& name, const QString& doc) :
      id(id), name(name), desc(doc) {}
    Descriptor(const QString& _id) : id(_id), name(_id), desc(_id)  {}
    Descriptor(const char* _id) : id(_id), name(_id), desc(_id)  {}
    Descriptor() {}
    virtual ~Descriptor() { }
    QString getId() const {return id;}
    QString getDisplayName() const {return name;}
    QString getDocumentation() const {return desc;}


    void setDisplayName(const QString& n) {name = n;}

    inline bool operator==(const Descriptor& d) const { return id == d.id; }
    inline bool operator!=(const Descriptor& d) const { return id != d.id; }
    inline bool operator==(const QString& s) const { return id == s; }
    inline bool operator!=(const QString& s) const { return id != s; }

    // neccessary for using with QMap
    inline bool operator<(const Descriptor& d) const { return id < d.id; }

protected:
    QString id;
    QString name, desc;
};

} //namespace

Q_DECLARE_METATYPE(GB2::Descriptor)
Q_DECLARE_METATYPE(QList<GB2::Descriptor>)

#endif
