/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DATATYPE_H_
#define _GB2_DATATYPE_H_

#include <workflow/Descriptor.h>
#include <core_api/IdRegistry.h>
#include <QtCore/QExplicitlySharedDataPointer>

namespace GB2 {

class DataType;
typedef QExplicitlySharedDataPointer<DataType> DataTypePtr;

// base class for datatypes
class WCOREAPI_EXPORT DataType : public Descriptor, public QSharedData {
public:
    enum Kind {
        Single,
        List,
        Map
    };
    
    DataType(const QString& id, const QString& name, const QString& desc);
    DataType(const Descriptor& d);
    virtual ~DataType() {}
    
    //virtual bool equals(DataTypePtr t) const {return t == this;}
    virtual Kind kind() const {return Single;}
    inline bool isSingle() const {return kind() == Single;}
    inline bool isMap() const {return kind() == Map;}
    inline bool isList() const {return kind() == List;}
    
    virtual DataTypePtr getDatatypeByDescriptor(const Descriptor& idd=Descriptor(QString())) const;
    virtual QList<Descriptor> getAllDescriptors() const;
    virtual QMap<Descriptor, DataTypePtr> getDatatypesMap() const;
    Descriptor getDatatypeDescriptor(const QString& id) const;
    
}; // DataType


class WCOREAPI_EXPORT MapDataType : public DataType {
public:
    MapDataType(const Descriptor& d, const QMap<Descriptor, DataTypePtr>& m);

    virtual DataType::Kind kind() const;
    virtual DataTypePtr getDatatypeByDescriptor(const Descriptor& d) const;
    virtual QList<Descriptor> getAllDescriptors() const;

    virtual QMap<Descriptor, DataTypePtr> getDatatypesMap() const;
    
    //TODO ???
    //virtual bool equals(DataTypePtr t) const {return t == this;} 
    //bool containsSubset(const MapDataType& sub) const;
    //MapDataType remap(const QMap<QString,QString>& m) const;
    
protected:
    QMap<Descriptor, DataTypePtr> map;
    
}; // MapDataType

class WCOREAPI_EXPORT ListDataType : public DataType {
public:
    ListDataType(const Descriptor& d, DataTypePtr el);
    
    virtual DataType::Kind kind() const;
    virtual DataTypePtr getDatatypeByDescriptor(const Descriptor& idd=Descriptor(QString())) const;
    
    //TODO ???
    //virtual bool equals(DataTypePtr t) const {return t == this;} 
    
protected:
    DataTypePtr listElementDatatype;
    
}; // ListDataType


class DataTypeRegistry {
public:
    virtual ~DataTypeRegistry();
    
    virtual DataTypePtr getById(const QString& id) const;
    virtual bool registerEntry(DataTypePtr t);
    virtual DataTypePtr unregisterEntry(const QString& id);

    virtual QList<DataTypePtr> getAllEntries() const;
    virtual QList<QString> getAllIds() const;

protected:
    QMap<QString, DataTypePtr> registry;
    
}; // DataTypeRegistry


class DataTypeValueFactory {
public:
    DataTypeValueFactory() {}
    virtual ~DataTypeValueFactory() {}
    
    virtual QVariant getValueFromString( const QString & str, bool * ok = NULL ) const = 0;
    virtual QString getId() const = 0;
    
}; // DataTypeValueFactory

typedef IdRegistry<DataTypeValueFactory> DataTypeValueFactoryRegistry;

} //namespace
#endif
