/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CopyDataTask.h"

#include <core_api/IOAdapter.h>
#include <core_api/L10n.h>

#include <QtCore/QString>
#include <QtCore/QByteArray>

#include <memory>

namespace GB2 {

CopyDataTask::CopyDataTask( IOAdapterFactory * _ioFrom, const GUrl& _urlFrom, 
						   IOAdapterFactory * _ioTo, const GUrl& _urlTo ) :
Task(tr("copy_data_task_name"), TaskFlag_None), ioFrom(_ioFrom), ioTo(_ioTo),
urlFrom(_urlFrom), urlTo(_urlTo)
{
	assert(ioFrom != NULL && ioTo != NULL);
	tpm = Progress_Manual;
}

void CopyDataTask::run() {
    std::auto_ptr<IOAdapter> from( ioFrom->createIOAdapter() );
    std::auto_ptr<IOAdapter> wheree( ioTo->createIOAdapter() );
    from->open( urlFrom, IOAdapterMode_Read );
    if (!from->isOpen()) {
        stateInfo.setError(L10N::errorOpeningFileRead(urlFrom));
        return;
    }
    wheree->open( urlTo, IOAdapterMode_Write );
    if (!from->isOpen()) {
        stateInfo.setError(L10N::errorOpeningFileWrite(urlTo));
        return;
    }
    
    qint64 count = 0;
    qint64 count_w = 0;
    QByteArray buff( BUFFSIZE, 0 );

    
    count = from->readBlock( buff.data(), BUFFSIZE );
    if (count == 0) {
        stateInfo.setError(tr("no data in the source"));
        return;
    }
    while( count > 0 ) {
        count_w = wheree->writeBlock( buff.data(), count );
        if( stateInfo.cancelFlag ) {
            break;
        }
        stateInfo.progress = from->getProgress();
        count = from->readBlock( buff.data(), BUFFSIZE );
    }
    if( count < 0 || count_w < 0 ) {
        if (!stateInfo.hasErrors()) {
            stateInfo.setError(tr("IO adapter error"));
        }
    }
}

}// namespace
