/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADV_SEQUENCE_WIDGET_H_
#define _GB2_ADV_SEQUENCE_WIDGET_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtGui/QAction>
#include <QtGui/QWidget>

namespace GB2 {

class AnnotatedDNAView;
class DNASequenceObject;
class DNASequenceSelection;
class ADVSequenceWidgetAction;
class ADVSequenceObjectContext;
class GObject;

class GB2_COREAPI_EXPORT ADVSequenceWidget : public QWidget {
    Q_OBJECT
public:
    ADVSequenceWidget(AnnotatedDNAView* ctx);

    AnnotatedDNAView* getAnnotatedDNAView() const {return ctx;}

    virtual QList<DNASequenceObject*> getSequenceObjects() const;
    virtual QList<ADVSequenceObjectContext*> getSequenceContexts() const {return seqContexts;}

    /** actions associated with this block. Automatically deleted with block*/
    virtual void addADVSequenceWidgetAction(ADVSequenceWidgetAction* action);
    
    ADVSequenceWidgetAction* getADVSequenceWidgetAction(const QString& objName) const;
    
    virtual ADVSequenceObjectContext* getActiveSequenceContext() const = 0;

    virtual void centerPosition(int pos, QWidget* skipView = NULL) = 0;

    virtual void buildPopupMenu(QMenu& m);

    //TODO: replace with GObjectViewObjectHandler
    virtual bool isWidgetOnlyObject(GObject* o) const { Q_UNUSED(o); return false;}

    virtual void updateState(const QVariantMap& m) {Q_UNUSED(m);}
    
    virtual void saveState(QVariantMap& m) {Q_UNUSED(m);}

    virtual LRegion getVisibleRange() const = 0;
    
    virtual void setVisibleRange(const LRegion& r) = 0;

    virtual int getNumBasesVisible() const = 0;

    virtual void setNumBasesVisible(int n) = 0;
    
signals:
    void si_sequenceObjectAdded(DNASequenceObject*);
    void si_sequenceObjectRemoved(DNASequenceObject* );
    
protected:
    AnnotatedDNAView*                   ctx;
    QList<ADVSequenceObjectContext*>    seqContexts;
    QList<ADVSequenceWidgetAction*>     wActions;
};

class GB2_COREAPI_EXPORT ADVSequenceWidgetAction : public QAction {
    Q_OBJECT
public:
    ADVSequenceWidgetAction(const QString& objName, const QString& text) 
        : QAction(text, NULL), addToBar(false), addToMenu(false), seqWidget(NULL) { setObjectName(objName); }

    bool                addToBar;
    bool                addToMenu;
    QString             afterMenu;
    ADVSequenceWidget*  seqWidget;
};


}//namespace

#endif
