/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_AVD_GRAPH_MODEL_H_
#define _GB2_AVD_GRAPH_MODEL_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtCore/QVector>
#include <QtGui/QPixmap>

namespace GB2 {

class DNASequenceObject;
class GSequenceGraphData;
class GSequenceGraphWindowData;
class GSequenceGraphView;

//BUG:402: refactor to remove cross references in structures!

class GB2_COREAPI_EXPORT GSequenceGraphAlgorithm {
public:
    virtual ~GSequenceGraphAlgorithm(){}
	virtual void calculate(QVector<float>& res, DNASequenceObject* o, const LRegion& r, const GSequenceGraphWindowData* d) = 0;
};

class GB2_COREAPI_EXPORT GSequenceGraphWindowData {
public:
    GSequenceGraphWindowData() :  step(0), window(0){}
    GSequenceGraphWindowData(int _step, int w) :  step(_step), window(w){}

    virtual ~GSequenceGraphWindowData(){};

    int					step;
    int					window;
};

class GB2_COREAPI_EXPORT GSequenceGraphMinMaxCutOffData {
public:
	GSequenceGraphMinMaxCutOffData() : min(0.0), max(0.0), e(false) {}
	GSequenceGraphMinMaxCutOffData(double _min, double _max, bool _e) : min(_min), max(_max), e(_e){}

	virtual ~GSequenceGraphMinMaxCutOffData(){};

	double min;
	double max;
	bool e;
};

struct PairVector	{
	QVector<float>	firstPoints;	//max if use both
	QVector<float>  secondPoints;
	bool useIntervals;
};


class GB2_COREAPI_EXPORT GSequenceGraphDrawer : public QObject{
    Q_OBJECT
public:
	GSequenceGraphDrawer(GSequenceGraphView* v, const GSequenceGraphWindowData& wd);
	virtual ~GSequenceGraphDrawer();
	
	virtual void draw(QPainter& p, GSequenceGraphData* d, const QRect& rect);
	
	virtual void showSettingsDialog();
    
    const GSequenceGraphWindowData& getWindowData() {return wdata;}
	const GSequenceGraphMinMaxCutOffData& getCutOffData() {return commdata;}

protected:
	void calculatePoints(GSequenceGraphData* d, PairVector& points, float& min, float& max, int numPoints);
	void calculateWithFit(GSequenceGraphData* d, PairVector& points, int alignedStart, int alignedEnd);
	void calculateWithExpand(GSequenceGraphData* d, PairVector& points, int alignedStart, int alignedEnd);

protected:
	GSequenceGraphView*		    view;
	QFont*					    defFont;

    GSequenceGraphWindowData    wdata;
	GSequenceGraphMinMaxCutOffData commdata;
};


class GB2_COREAPI_EXPORT GSequenceGraphData {
public:
    GSequenceGraphData(const QString& _graphName);
    virtual ~GSequenceGraphData();

    QString						graphName;
    GSequenceGraphAlgorithm*	ga;

    int                         cachedFrom, cachedLen, cachedW, cachedS;
    int						    alignedFC, alignedLC;
    PairVector                  cachedData;
};


class GB2_COREAPI_EXPORT GSequenceGraphUtils {
public:
	static int getNumSteps(const LRegion& range, int w, int s);

	static void fitToScreen(const QVector<float>& data, int dataStartBase, int dataEndBase, 
							QVector<float>& results,  int resultStartBase, int resultEndBase, 
							int screenWidth, float unknownVal);

	static float calculateAverage(const QVector<float>& data, float start, float range);
	static void calculateMinMax(const QVector<float>& data, float& min, float& max);

};

} // namespace

#endif
