/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "MSAConsensusAlgorithmRegistry.h"

#include "MSAConsensusAlgorithmDefault.h"
#include "MSAConsensusAlgorithmStrict.h"
#include "MSAConsensusAlgorithmClustal.h"
#include "MSAConsensusAlgorithmLevitsky.h"

namespace GB2 {

MSAConsensusAlgorithmRegistry::MSAConsensusAlgorithmRegistry(QObject* p) : QObject(p) {
	addAlgorithm(new MSAConsensusAlgorithmFactoryDefault());
	addAlgorithm(new MSAConsensusAlgorithmFactoryStrict());
	addAlgorithm(new MSAConsensusAlgorithmFactoryClustal());
    addAlgorithm(new MSAConsensusAlgorithmFactoryLevitsky());
}

MSAConsensusAlgorithmRegistry::~MSAConsensusAlgorithmRegistry() {
	QList<MSAConsensusAlgorithmFactory*> list = algorithms.values();
	foreach(MSAConsensusAlgorithmFactory* algo, list) {
		delete algo;
	}
}

MSAConsensusAlgorithmFactory* MSAConsensusAlgorithmRegistry::getAlgorithmFactory(const QString& algoId) {
	return algorithms.value(algoId);
}


void MSAConsensusAlgorithmRegistry::addAlgorithm(MSAConsensusAlgorithmFactory* algo) {
	const QString& id = algo->getId();
	MSAConsensusAlgorithmFactory* oldVersion = algorithms.value(id);
	if (oldVersion!=NULL) {
		delete oldVersion;
        oldVersion = NULL;
	}
	algorithms[id] = algo;
}

QStringList MSAConsensusAlgorithmRegistry::getAlgorithmIds() const  {
	QList<MSAConsensusAlgorithmFactory*> list = algorithms.values();
	QStringList result;
	foreach(MSAConsensusAlgorithmFactory* algo, list) {
		result.append(algo->getId());
	}
	return result;
}

QList<MSAConsensusAlgorithmFactory*> MSAConsensusAlgorithmRegistry::getAlgorithmFactories(ConsensusAlgorithmFlags flags) const {
    QList<MSAConsensusAlgorithmFactory*> allFactories = getAlgorithmFactories();
    QList<MSAConsensusAlgorithmFactory*> result;
    foreach(MSAConsensusAlgorithmFactory* f, allFactories) {
        if ((flags & f->getFlags()) == flags) {
            result.append(f);
        }
    }
    return result;
}

}//namespace
