/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOVE_PART_FROM_SEQUENCE_CONTROLLER_H_
#define _GB2_REMOVE_PART_FROM_SEQUENCE_CONTROLLER_H_

#include "ui/ui_RemovePartFromSequenceDialog.h"
#include <util_gui/DialogUtils.h>
#include <core_api/LRegion.h>
#include <util_tasks/RemovePartFromSequenceTask.h>


namespace GB2{

class GB2_COREAPI_EXPORT RemovePartFromSequenceDialogController : public QDialog, public Ui_RemovePartFromSequenceDialog {
    Q_OBJECT
public:
    RemovePartFromSequenceDialogController(LRegion _toDelete, LRegion _source, QWidget *p = NULL);
    virtual void accept();

    bool modifyCurrentDocument(){return !saveToAnotherBox->isChecked();};
    QString getNewDocumentPath(){return filepathEdit->text();};
    RemovePartFromSequenceTask::AnnotationStrategyForRemove getStrategy();
    LRegion getRegionToDelete(){return toDelete;};
    bool mergeAnnotations(){return (mergeAnnotationsBox->isChecked() && !modifyCurrentDocument());};
    DocumentFormatId getDocumentFormatId(){return formatBox->itemData(formatBox->currentIndex()).toString();};

private slots:
    void sl_browseButtonClicked();
    void sl_indexChanged(int);
    void sl_mergeAnnotationsToggled(bool);

private:
    QString filter;
    LRegion toDelete;
    LRegion source;
};

}//ns

#endif

