/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_REMOTE_MACHINE_MONITOR_DIALOG_IMPL_H_
#define _GB2_REMOTE_MACHINE_MONITOR_DIALOG_IMPL_H_

#include <QtGui/QMenu>
#include <distributed_computing/RemoteMachine.h>
#include <distributed_computing/RemoteMachineMonitor.h>

#include <ui/ui_RemoteMachineMonitorDialog.h>

class QCheckBox;

namespace GB2 {

class RemoteTask;
class RetrievePublicMachinesTask;

enum RemoteMachineState {
    MACHINE_OLD,
    MACHINE_NEW,
    MACHINE_DELETED
}; // RemoteMachineState

struct RemoteMachineMonitorDialogItem {
    RemoteMachineSettings * settings;
    RemoteMachineState      state;
    QCheckBox *             cb;
    QStringList             servicesList;
    QUuid                   machineUuid;
    QString                 hostname;
    
    RemoteMachineMonitorDialogItem( RemoteMachineSettings * s, RemoteMachineState st, QCheckBox * sel ) 
        : settings( s ), state( st ), cb( sel ) {
        assert( NULL != settings );
    }
    RemoteMachineMonitorDialogItem() 
        : settings( NULL ), state( MACHINE_OLD ), cb( NULL ) {
    }
    
}; // RemoteMachineMonitorDialogItem

class GB2_COREAPI_EXPORT RemoteMachineMonitorDialogImpl : public QDialog, Ui::RemoteMachineMonitorDialog {
    Q_OBJECT
private:
    static const QString OK_BUTTON_RUN;
    static const int CHECKBOX_SIZE_HINT_MAGIC_NUMBER = 2;
    static const QString SAVE_SETTINGS_FILE_DOMAIN;
    
public:
    RemoteMachineMonitorDialogImpl( QWidget * p, const QList< RemoteMachineMonitorItem > & monitorItems,
                                    const QString & taskFactoryId = QString() );
    
    QList< RemoteMachineMonitorDialogItem > getModel() const;
    
private:
    bool addMachine( RemoteMachineSettings * machine, RemoteMachineState state, bool select );
    QTreeWidgetItem * addItemToTheView( RemoteMachineMonitorDialogItem & item );
    int topLevelItemsSelectedNum() const;
    int getSelectedTopLevelRow() const;
    bool hasSameMachineInTheView( RemoteMachineSettings * machine ) const;
    QTreeWidgetItem * findTopLevelWidgetItem( QCheckBox * cb );
    void enableItem( QTreeWidgetItem * item, bool enable );
    void processNewItemInfo( const RemoteMachineMonitorDialogItem & item );
    bool removeDialogItemAt( int row ); /* returns if item was successfully removed */
    void checkBoxStateChanged( QCheckBox * cb, bool enable );
    void checkUuids() const; // returns what machines have equal uuid's
    QString hasEqualUuids( RemoteMachineSettings * i, RemoteMachineSettings * j ) const;
    void pingMachine( RemoteMachineSettings * settings, QTreeWidgetItem * item );
    void resizeTreeWidget();
    void initMachineActionsMenu();
    
private slots:
    void sl_scanPushButtonClicked();
    void sl_okPushButtonClicked();
    void sl_cancelPushButtonClicked();
    void sl_addPushButtonClicked();
    void sl_removePushButtonClicked();
    void sl_modifyPushButtonClicked();
    void sl_selectionChanged();
    void sl_rejected();
    void sl_checkBoxStateChanged( int );
    void sl_retrieveInfoTaskStateChanged();
    void sl_pingPushButtonClicked();
    void sl_getPublicMachinesButtonClicked();
    void sl_getPublicMachinesTaskStateChanged();
    void sl_machinesTreeMenuRequested(const QPoint&);
    void sl_saveMachine();
    
private:
    QMenu * machineActionsMenu;
    QList< RemoteMachineMonitorDialogItem > machinesItemsByOrder;
    QList< RemoteMachineMonitorDialogItem > deletedOldMachines;
    /* when dialog is called to select machines for running remote task. if not, taskFactoryId is empty (default) */
    QString                                 taskFactoryId;
    
    QMap< RemoteMachine *, QTreeWidgetItem * > pingingItems; /* ping sent to machines with this items */
    
    /* not static because QApplication must be constructed before any graphical object */
    const QPixmap PING_YES;
    const QPixmap PING_NO;
    const QPixmap PING_WAIT_FOR_RESPONSE;
    
    RetrievePublicMachinesTask * getPublicMachinesTask;
    
}; // RemoteMachineMonitorDialogImpl

} // GB2

#endif // _GB2_REMOTE_MACHINE_MONITOR_DIALOG_IMPL_H_
