/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QXmlInputSource>
#include <QMessageBox>

#include <core_api/AppContext.h>
#include <core_api/DBXRefRegistry.h>
#include <util_tasks/LoadRemoteDocumentTask.h>

#include "DownloadRemoteFileDialog.h"

namespace GB2 {

QString DownloadRemoteFileDialog::defaultDB("");

DownloadRemoteFileDialog::DownloadRemoteFileDialog(QWidget *p):QDialog(p), isQueryDB(false)
{
    setupUi(this);
    
    connect(databasesBox, SIGNAL(currentIndexChanged ( const QString&)), SLOT( sl_updateHint(const QString&)));
    
    RemoteDBRegistry& registry = RemoteDBRegistry::getRemoteDBRegistry();
    const QList<QString> dataBases = registry.getDBs(); 
    foreach(const QString& dbName, dataBases) {
        databasesBox->addItem(dbName);
    }
    
    if (!defaultDB.isEmpty()) {
        int index = databasesBox->findText(defaultDB);
        Q_ASSERT(index < dataBases.count());
        databasesBox->setCurrentIndex(index);
    }
    
    
}


QString DownloadRemoteFileDialog::getResourceId()
{
    return idLineEdit->text().trimmed();
}

QString DownloadRemoteFileDialog::getDBName() 
{   
    return databasesBox->currentText();
}

void DownloadRemoteFileDialog::accept()
{
    
    if (!getResourceId().isEmpty()) {
        Task* task = new LoadRemoteDocumentAndOpenViewTask(getResourceId(), getDBName());
        AppContext::getTaskScheduler()->registerTopLevelTask(task);
    }
    defaultDB = getDBName();
    QDialog::accept();

}

void DownloadRemoteFileDialog::sl_updateHint(const QString& dbName) {
    RemoteDBRegistry& registry = RemoteDBRegistry::getRemoteDBRegistry();
    QString hint = registry.getHint(dbName);
    hintLabel->setText(hint);
    idLineEdit->setToolTip(hint);
}


} //namespace 
