/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_ASSEMBLEY_UTILS_H_
#define _GB2_DNA_ASSEMBLEY_UTILS_H_

#include <core_api/core_api.h>
#include <core_api/GUrl.h>
#include <core_api/Task.h>

#include "DnaAssemblyTask.h"

namespace GB2 {

class DnaAssemblyToRefTaskSettings;
class AddDocumentTask;

class GB2_COREAPI_EXPORT DnaAssemblySupport : public QObject {
    Q_OBJECT
public:
    DnaAssemblySupport();

private slots:
    void sl_showDnaAssemblyDialog();

}; 

class DnaAssemblyLoadShortReadsTask : public Task {
    Q_OBJECT
public:
    DnaAssemblyLoadShortReadsTask(DnaAssemblyToRefTaskSettings& settings, const QList<GUrl>& shortReads);
    virtual void prepare();
    QList<Task*> onSubTaskFinished(Task* subTask);
    virtual ReportResult report();
private:
    DnaAssemblyToRefTaskSettings& settings;
    const QList<GUrl>& shortReads;
}; 

class Document;
class AddDocumentTask;

class DnaAssemblyMultiTask : public Task {
    Q_OBJECT
public:
    DnaAssemblyMultiTask(const DnaAssemblyToRefTaskSettings& settings, const QList<GUrl>& shortReadUrls, bool viewResult);
    virtual void prepare();
    virtual ReportResult report();
    QList<Task*> onSubTaskFinished(Task* subTask);
    const MAlignment& getAssemblyResult();

private:
    DnaAssemblyToRefTaskSettings settings;
    DnaAssemblyToReferenceTask* assemblyToRefTask;
    AddDocumentTask* addDocumentTask;
    Document* doc;
    QList<GUrl> shortReadUrls;
    bool openView;
}; 


} // GB2


#endif // _GB2_DNA_ASSEMBLEY_TASK_H_
